/* This file is part of the KDE project
   Copyright (C) 2001 Andrea Rizzi <rizzi@kde.org>
	              Ulrich Kuettler <ulrich.kuettler@mailbox.tu-dresden.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqvariant.h>   // first for gcc 2.7.2
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqmap.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>
#include <tqstringlist.h>
#include <tqvbox.h>
#include <tqwidget.h>

//#include <algorithm>

#include <kcolorbutton.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kfontdialog.h>
#include <klistview.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <kpushbutton.h>

#include "contextstyle.h"
#include "kformulaconfigpage.h"
#include "kformuladocument.h"
#include "symboltable.h"


KFORMULA_NAMESPACE_BEGIN


ConfigurePage::ConfigurePage( Document* document, TQWidget* view, KConfig* config, TQVBox* box, char* name )
    : TQObject( box->parent(), name ), m_document( document ), m_view( view ), m_config( config ), m_changed( false )
{
    const ContextStyle& contextStyle = document->getContextStyle( true );

    // fonts

    TQGroupBox *gbox = new TQGroupBox( i18n( "Fonts" ), box );
    gbox->setColumnLayout( 0, Qt::Horizontal );

    TQGridLayout* grid = new TQGridLayout( gbox->layout(), 5, 3 );
    grid->setSpacing( KDialog::spacingHint() );

    grid->setColStretch(1, 1);

    defaultFont = contextStyle.getDefaultFont();
    nameFont = contextStyle.getNameFont();
    numberFont = contextStyle.getNumberFont();
    operatorFont = contextStyle.getOperatorFont();

    connect( buildFontLine( gbox, grid, 0, defaultFont,
            i18n( "Default font:" ), defaultFontName ),
            TQT_SIGNAL( clicked() ), TQT_SLOT( selectNewDefaultFont() ) );

    connect( buildFontLine( gbox, grid, 1, nameFont,
            i18n( "Name font:" ), nameFontName ),
            TQT_SIGNAL( clicked() ), TQT_SLOT( selectNewNameFont() ) );

    connect( buildFontLine( gbox, grid, 2, numberFont,
            i18n( "Number font:" ), numberFontName ),
            TQT_SIGNAL( clicked() ), TQT_SLOT( selectNewNumberFont() ) );

    connect( buildFontLine( gbox, grid, 3, operatorFont,
            i18n( "Operator font:" ), operatorFontName ),
            TQT_SIGNAL( clicked() ), TQT_SLOT( selectNewOperatorFont() ) );

    TQLabel* sizeTitle = new TQLabel( i18n( "Default base size:" ), gbox );
    grid->addWidget( sizeTitle, 4, 0 );

    sizeSpin = new KIntNumInput( contextStyle.baseSize(), gbox );
    sizeSpin->setRange( 8, 72, 1, true );

    grid->addMultiCellWidget( sizeSpin, 4, 4, 1, 2 );

    connect( sizeSpin, TQT_SIGNAL( valueChanged( int ) ),
            TQT_SLOT( baseSizeChanged( int ) ) );

    // syntax highlighting

    syntaxHighlighting = new TQCheckBox( i18n( "Use syntax highlighting" ),box );
    syntaxHighlighting->setChecked( contextStyle.syntaxHighlighting() );

//     hlBox = new TQGroupBox( i18n( "Highlight Colors" ), box );
//     hlBox->setColumnLayout( 0, Qt::Horizontal );

//     grid = new TQGridLayout( hlBox->layout(), 5, 2 );
//     grid->setSpacing( KDialog::spacingHint() );

//     TQLabel* defaultLabel = new TQLabel( hlBox, "defaultLabel" );
//     defaultLabel->setText( i18n( "Default color:" ) );
//     grid->addWidget( defaultLabel, 0, 0 );

//     defaultColorBtn = new KColorButton( hlBox, "defaultColor" );
//     defaultColorBtn->setColor( contextStyle.getDefaultColor() );
//     grid->addWidget( defaultColorBtn, 0, 1 );


//     TQLabel* numberLabel = new TQLabel( hlBox, "numberLabel" );
//     numberLabel->setText( i18n( "Number color:" ) );
//     grid->addWidget( numberLabel, 1, 0 );

//     numberColorBtn = new KColorButton( hlBox, "numberColor" );
//     numberColorBtn->setColor( contextStyle.getNumberColorPlain() );
//     grid->addWidget( numberColorBtn, 1, 1 );


//     TQLabel* operatorLabel = new TQLabel( hlBox, "operatorLabel" );
//     operatorLabel->setText( i18n( "Operator color:" ) );
//     grid->addWidget( operatorLabel, 2, 0 );

//     operatorColorBtn = new KColorButton( hlBox, "operatorColor" );
//     operatorColorBtn->setColor( contextStyle.getOperatorColorPlain() );
//     grid->addWidget( operatorColorBtn, 2, 1 );


//     TQLabel* emptyLabel = new TQLabel( hlBox, "emptyLabel" );
//     emptyLabel->setText( i18n( "Empty color:" ) );
//     grid->addWidget( emptyLabel, 3, 0 );

//     emptyColorBtn = new KColorButton( hlBox, "emptyColor" );
//     emptyColorBtn->setColor( contextStyle.getEmptyColorPlain() );
//     grid->addWidget( emptyColorBtn, 3, 1 );


//     TQLabel* errorLabel = new TQLabel( hlBox, "errorLabel" );
//     errorLabel->setText( i18n( "Error color:" ) );
//     grid->addWidget( errorLabel, 4, 0 );

//     errorColorBtn = new KColorButton( hlBox, "errorColor" );
//     errorColorBtn->setColor( contextStyle.getErrorColorPlain() );
//     grid->addWidget( errorColorBtn, 4, 1 );

    connect( syntaxHighlighting, TQT_SIGNAL( clicked() ),
            TQT_SLOT( syntaxHighlightingClicked() ) );

    syntaxHighlightingClicked();

    connect( syntaxHighlighting, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotChanged() ) );
    connect( sizeSpin, TQT_SIGNAL( valueChanged( int ) ), this, TQT_SLOT( slotChanged() ) );

    Q_ASSERT( !m_changed );
}


TQPushButton* ConfigurePage::buildFontLine( TQWidget* parent,
            TQGridLayout* layout, int number, TQFont font, TQString name,
            TQLabel*& fontName )
{
    TQLabel* fontTitle = new TQLabel( name, parent );

    TQString labelName = font.family() + ' ' + TQString::number( font.pointSize() );
    fontName = new TQLabel( labelName, parent );
    fontName->setFont( font );
    fontName->setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);

    TQPushButton* chooseButton = new TQPushButton( i18n( "Choose..." ), parent );

    layout->addWidget( fontTitle, number, 0 );
    layout->addWidget( fontName, number, 1 );
    layout->addWidget( chooseButton, number, 2 );

    return chooseButton;
}


void ConfigurePage::apply()
{
    if ( !m_changed )
        return;

    ContextStyle& contextStyle = m_document->getContextStyle( true );

    contextStyle.setDefaultFont( defaultFont );
    contextStyle.setNameFont( nameFont );
    contextStyle.setNumberFont( numberFont );
    contextStyle.setOperatorFont( operatorFont );
    contextStyle.setBaseSize( sizeSpin->value() );

    contextStyle.setSyntaxHighlighting( syntaxHighlighting->isChecked() );
//     contextStyle.setDefaultColor( defaultColorBtn->color() );
//     contextStyle.setNumberColor( numberColorBtn->color() );
//     contextStyle.setOperatorColor( operatorColorBtn->color() );
//     contextStyle.setEmptyColor( emptyColorBtn->color() );
//     contextStyle.setErrorColor( errorColorBtn->color() );

    m_config->setGroup( "kformula Font" );
    m_config->writeEntry( "defaultFont", TQString(defaultFont.toString()) );
    m_config->writeEntry( "nameFont", TQString(nameFont.toString()) );
    m_config->writeEntry( "numberFont", TQString(numberFont.toString()) );
    m_config->writeEntry( "operatorFont", TQString(operatorFont.toString()) );
    m_config->writeEntry( "baseSize", TQString::number( sizeSpin->value() ) );

//     m_config->setGroup( "kformula Color" );
//     m_config->writeEntry( "syntaxHighlighting", syntaxHighlighting->isChecked() );
//     m_config->writeEntry( "defaultColor", defaultColorBtn->color() );
//     m_config->writeEntry( "numberColor",  numberColorBtn->color() );
//     m_config->writeEntry( "operatorColor", operatorColorBtn->color() );
//     m_config->writeEntry( "emptyColor", emptyColorBtn->color() );
//     m_config->writeEntry( "errorColor", errorColorBtn->color() );

    // notify!!!
    m_document->updateConfig();
    m_changed = false;
}

void ConfigurePage::slotDefault()
{
    defaultFont = TQFont( "Times", 12, TQFont::Normal, true );
    nameFont = TQFont( "Times" );
    numberFont = nameFont;
    operatorFont = nameFont;

    sizeSpin->setValue( 20 );

    updateFontLabel( defaultFont, defaultFontName );
    updateFontLabel( nameFont, nameFontName );
    updateFontLabel( numberFont, numberFontName );
    updateFontLabel( operatorFont, operatorFontName );

    syntaxHighlighting->setChecked( true );
    syntaxHighlightingClicked();

//     defaultColorBtn->setColor( TQt::black );
//     numberColorBtn->setColor( TQt::blue );
//     operatorColorBtn->setColor( TQt::darkGreen );
//     emptyColorBtn->setColor( TQt::blue );
//     errorColorBtn->setColor( TQt::darkRed );
    slotChanged();
}

void ConfigurePage::syntaxHighlightingClicked()
{
//     bool checked = syntaxHighlighting->isChecked();
//     hlBox->setEnabled( checked );
}

void ConfigurePage::selectNewDefaultFont()
{
    if ( selectFont( defaultFont ) )
        updateFontLabel( defaultFont, defaultFontName );
}

void ConfigurePage::selectNewNameFont()
{
    if ( selectFont( nameFont ) )
        updateFontLabel( nameFont, nameFontName );
}

void ConfigurePage::selectNewNumberFont()
{
    if ( selectFont( numberFont ) )
        updateFontLabel( numberFont, numberFontName );
}

void ConfigurePage::selectNewOperatorFont()
{
    if ( selectFont( operatorFont ) )
        updateFontLabel( operatorFont, operatorFontName );
}

bool ConfigurePage::selectFont( TQFont & font )
{
    TQStringList list;

    KFontChooser::getFontList( list, KFontChooser::SmoothScalableFonts );

    KFontDialog dlg( m_view, 0, false, true, list );
    dlg.setFont( font );

    int result = dlg.exec();
    if (  KDialog::Accepted == result ) {
        font = dlg.font();
        slotChanged();
        return true;
    }

    return false;
}

void ConfigurePage::baseSizeChanged( int /*value*/ )
{
}

void ConfigurePage::updateFontLabel( TQFont font, TQLabel* label )
{
    label->setText( font.family() + ' ' + TQString::number( font.pointSize() ) );
    label->setFont( font );
}

void ConfigurePage::slotChanged()
{
    m_changed = true;
}

// class UsedFontItem : public KListViewItem {
// public:
//     UsedFontItem( MathFontsConfigurePage* page, TQListView* parent, TQString font )
//         : KListViewItem( parent, font ), m_page( page ) {}

//     int compare( TQListViewItem* i, int col, bool ascending ) const;

// private:
//     MathFontsConfigurePage* m_page;
// };

// int UsedFontItem::compare( TQListViewItem* i, int, bool ) const
// {
//     TQValueVector<TQString>::iterator lhsIt = m_page->findUsedFont( text( 0 ) );
//     TQValueVector<TQString>::iterator rhsIt = m_page->findUsedFont( i->text( 0 ) );
//     if ( lhsIt < rhsIt ) {
//         return -1;
//     }
//     else if ( lhsIt > rhsIt ) {
//         return 1;
//     }
//     return 0;
// }

// MathFontsConfigurePage::MathFontsConfigurePage( Document* document, TQWidget* view,
//                                                 KConfig* config, TQVBox* box, char* name )
//     : TQObject( box->parent(), name ), m_document( document ), m_view( view ), m_config( config )
// {
//     TQWidget* fontWidget = new TQWidget( box );
//     TQGridLayout* fontLayout = new TQGridLayout( fontWidget, 1, 1, KDialog::marginHint(), KDialog::spacingHint() );

//     TQHBoxLayout* hLayout = new TQHBoxLayout( 0, 0, 6 );

//     availableFonts = new KListView( fontWidget );
//     availableFonts->addColumn( i18n( "Available Fonts" ) );
//     hLayout->addWidget( availableFonts );

//     TQVBoxLayout* vLayout = new TQVBoxLayout( 0, 0, 6 );
//     TQSpacerItem* spacer1 = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
//     vLayout->addItem( spacer1 );

//     addFont = new KPushButton( fontWidget );
//     addFont->setText( "->" );
//     vLayout->addWidget( addFont );

//     removeFont = new KPushButton( fontWidget );
//     removeFont->setText( "<-" );
//     vLayout->addWidget( removeFont );

//     TQSpacerItem* spacer2 = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
//     vLayout->addItem( spacer2 );

//     hLayout->addLayout( vLayout );

//     vLayout = new TQVBoxLayout( 0, 0, 6 );

//     moveUp = new KPushButton( fontWidget );
//     moveUp->setText( i18n( "Up" ) );
//     vLayout->addWidget( moveUp );

//     requestedFonts = new KListView( fontWidget );
//     requestedFonts->addColumn( i18n( "Used Fonts" ) );
//     vLayout->addWidget( requestedFonts );

//     moveDown = new KPushButton( fontWidget );
//     moveDown->setText( i18n( "Down" ) );
//     vLayout->addWidget( moveDown );

//     hLayout->addLayout( vLayout );

//     fontLayout->addLayout( hLayout, 0, 0 );

// //     connect( availableFonts, TQT_SIGNAL( executed( TQListViewItem* ) ),
// //              this, TQT_SLOT( slotAddFont() ) );
// //     connect( requestedFonts, TQT_SIGNAL( executed( TQListViewItem* ) ),
// //              this, TQT_SLOT( slotRemoveFont() ) );
//     connect( addFont, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotAddFont() ) );
//     connect( removeFont, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotRemoveFont() ) );
//     connect( moveUp, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotMoveUp() ) );
//     connect( moveDown, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotMoveDown() ) );

//     const ContextStyle& contextStyle = document->getContextStyle( true );
//     const SymbolTable& symbolTable = contextStyle.symbolTable();
//     const TQStringList& usedFonts = contextStyle.requestedFonts();

//     TQMap<TQString, TQString> fontMap;
// //    symbolTable.findAvailableFonts( &fontMap );

//     setupLists( usedFonts );
// }

// void MathFontsConfigurePage::apply()
// {
//     TQStringList strings;
//     std::copy( usedFontList.begin(), usedFontList.end(), std::back_inserter( strings ) );

//     m_config->setGroup( "kformula Font" );
//     m_config->writeEntry( "usedMathFonts", strings );

//     ContextStyle& contextStyle = m_document->getContextStyle( true );
//     contextStyle.setRequestedFonts( strings );
// }

// void MathFontsConfigurePage::slotDefault()
// {
//     TQStringList usedFonts;

//     usedFonts.push_back( "esstixone" );
//     usedFonts.push_back( "esstixtwo" );
//     usedFonts.push_back( "esstixthree" );
//     usedFonts.push_back( "esstixfour" );
//     usedFonts.push_back( "esstixfive" );
//     usedFonts.push_back( "esstixsix" );
//     usedFonts.push_back( "esstixseven" );
//     usedFonts.push_back( "esstixeight" );
//     usedFonts.push_back( "esstixnine" );
//     usedFonts.push_back( "esstixten" );
//     usedFonts.push_back( "esstixeleven" );
//     usedFonts.push_back( "esstixtwelve" );
//     usedFonts.push_back( "esstixthirteen" );
//     usedFonts.push_back( "esstixfourteen" );
//     usedFonts.push_back( "esstixfifteen" );
//     usedFonts.push_back( "esstixsixteen" );
//     usedFonts.push_back( "esstixseventeen" );

//     usedFontList.clear();
//     requestedFonts->clear();
//     availableFonts->clear();

//     setupLists( usedFonts );
// }

// TQValueVector<TQString>::iterator MathFontsConfigurePage::findUsedFont( TQString name )
// {
//     return std::find( usedFontList.begin(), usedFontList.end(), name );
// }

// void MathFontsConfigurePage::setupLists( const TQStringList& usedFonts )
// {
//     const ContextStyle& contextStyle = m_document->getContextStyle( true );
//     const SymbolTable& symbolTable = contextStyle.symbolTable();

//     TQMap<TQString, TQString> fontMap;
// //    symbolTable.findAvailableFonts( &fontMap );

//     for ( TQStringList::const_iterator it = usedFonts.begin(); it != usedFonts.end(); ++it ) {
//         TQMap<TQString, TQString>::iterator font = fontMap.find( *it );
//         if ( font != fontMap.end() ) {
//             fontMap.erase( font );
//             new UsedFontItem( this, requestedFonts, *it );
//             usedFontList.push_back( *it );
//         }
//     }
//     for ( TQMap<TQString, TQString>::iterator it = fontMap.begin(); it != fontMap.end(); ++it ) {
//         new KListViewItem( availableFonts, it.key() );
//     }
// }

// void MathFontsConfigurePage::slotAddFont()
// {
//     TQListViewItem* fontItem = availableFonts->selectedItem();
//     if ( fontItem ) {
//         TQString fontName = fontItem->text( 0 );
//         //availableFonts->takeItem( fontItem );
//         delete fontItem;

//         new UsedFontItem( this, requestedFonts, fontName );
//         usedFontList.push_back( fontName );
//     }
// }

// void MathFontsConfigurePage::slotRemoveFont()
// {
//     TQListViewItem* fontItem = requestedFonts->selectedItem();
//     if ( fontItem ) {
//         TQString fontName = fontItem->text( 0 );
//         TQValueVector<TQString>::iterator it = std::find( usedFontList.begin(), usedFontList.end(), fontName );
//         if ( it != usedFontList.end() ) {
//             usedFontList.erase( it );
//         }
//         //requestedFonts->takeItem( fontItem );
//         delete fontItem;
//         new KListViewItem( availableFonts, fontName );
//     }
// }

// void MathFontsConfigurePage::slotMoveUp()
// {
//     TQListViewItem* fontItem = requestedFonts->selectedItem();
//     if ( fontItem ) {
//         TQString fontName = fontItem->text( 0 );
//         TQValueVector<TQString>::iterator it = std::find( usedFontList.begin(), usedFontList.end(), fontName );
//         if ( it != usedFontList.end() ) {
//             uint pos = it - usedFontList.begin();
//             if ( pos > 0 ) {
//                 TQValueVector<TQString>::iterator before = it-1;
//                 std::swap( *it, *before );
//                 requestedFonts->sort();
//             }
//         }
//     }
// }

// void MathFontsConfigurePage::slotMoveDown()
// {
//     TQListViewItem* fontItem = requestedFonts->selectedItem();
//     if ( fontItem ) {
//         TQString fontName = fontItem->text( 0 );
//         TQValueVector<TQString>::iterator it = std::find( usedFontList.begin(), usedFontList.end(), fontName );
//         if ( it != usedFontList.end() ) {
//             uint pos = it - usedFontList.begin();
//             if ( pos < usedFontList.size()-1 ) {
//                 TQValueVector<TQString>::iterator after = it+1;
//                 std::swap( *it, *after );
//                 requestedFonts->sort();
//             }
//         }
//     }
// }

KFORMULA_NAMESPACE_END

using namespace KFormula;
#include "kformulaconfigpage.moc"
