/* This file is part of the KDE project
   Original file (mailmerge.h): Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _SERIALLETTER_INTERFACE_H_
#define _SERIALLETTER_INTERFACE_H_
#include <tqcstring.h>
#include <tqdom.h>
#include <kinstance.h>
#include <tqmap.h>
#include <tqobject.h>
#include <dcopobject.h>
#include <koffice_export.h>
typedef TQMap<TQString,TQString> DbRecord;
#define KWSLUnspecified 0
#define KWSLEdit 1
#define KWSLCreate 2
#define KWSLOpen 3
#define KWSLMergePreview 4
#define KWSLMergeDocument 5

#define KWSLCreate_text "create"
#define KWSLOpen_text "open"
/******************************************************************
 *
 * Class: KWMailMergeDataSource
 *
 ******************************************************************/

class KWORD_EXPORT KWMailMergeDataSource: public TQObject, public DCOPObject
{
    Q_OBJECT
//    TQ_OBJECT
    K_DCOP
    public:
    KWMailMergeDataSource(KInstance* inst,TQObject *parent);
    virtual ~KWMailMergeDataSource(){;}
    virtual class TQString getValue( const class TQString &name, int record = -1 ) const=0;

    const TQMap< TQString, TQString > &getRecordEntries() const;

    KInstance *KWInstance(){return m_instance;}
    virtual  bool showConfigDialog(class TQWidget*,int) =0;

    virtual void save(TQDomDocument&, TQDomElement&)=0;
    virtual void load( class TQDomElement& elem )=0;

    virtual void refresh(bool force)=0;
    TQByteArray info;
    protected:
    DbRecord sampleRecord;
    private:
    KInstance *m_instance;
k_dcop:
    virtual  int getNumRecords() const =0;
};




#endif
