/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   Modified by Joseph wenninger, 2001

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef mailmerge_h
#define mailmerge_h

#include <kdialogbase.h>
#include <ktrader.h>


#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqdom.h>
#include <tqtextstream.h>

#include "KWMailMergeDataSource.h"
#include "KWordMailMergeDatabaseIface.h"
#include <koffice_export.h>

class TQListBox;
class TQPushButton;
class TQLineEdit;
class TQSpinBox;
class KWDocument;
class TQVBox;

//class KWMailMergeDataBase;




/******************************************************************
 *
 * Class: KWMailMergeDataBase
 *
 ******************************************************************/

class KWORD_EXPORT KWMailMergeDataBase: public TQObject,KWordMailMergeDatabaseIface
{
Q_OBJECT
  TQ_OBJECT

public:
    KWMailMergeDataBase( KWDocument *doc_ );
    void showConfigDialog(TQWidget *); // Select datasource type  and / or configure datasource

    TQString getValue( const TQString &name, int record = -1 ) const;  //accesses the plugin
    bool isSampleRecord();

    const TQMap< TQString, TQString > &getRecordEntries() const; //accesses the plugin
    int getNumRecords() const; //accesses the plugin

    TQDomElement save(TQDomDocument &doc) const; // save some global config + plugin config
    void load( const TQDomElement& elem ); // save some global config + plugin config

    KWMailMergeDataSource *loadPlugin(const TQString& name);
    KWMailMergeDataSource *openPluginFor(int type,int &version);

    virtual void refresh(bool force);
    virtual TQStringList availablePlugins();
    virtual bool loadPlugin(const TQString &name,const TQString &command);
    virtual bool isConfigDialogShown();
    
    int version();
private:
    int m_version;
protected:
    friend class KWMailMergeConfigDialog;
    KWDocument *doc;
    int action;
    class KWMailMergeDataSource *plugin;
    TQMap<TQString, TQString> emptyMap;
    bool askUserForConfirmationAndConfig(KWMailMergeDataSource *tmpPlugin,bool config,TQWidget *par,int version);
    bool rejectdcopcall;
};


class KWMailMergeChoosePluginDialog : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KWMailMergeChoosePluginDialog( KTrader::OfferList );
    ~KWMailMergeChoosePluginDialog();

    int currentPlugin() const;    

  private slots:
    void pluginChanged( int pos );

  private:
    class TQComboBox *chooser;
    class TQLabel *descriptionLabel;
    KTrader::OfferList pluginOffers;
};

class KWMailMergeConfigDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
   KWMailMergeConfigDialog ( TQWidget *parent, KWMailMergeDataBase *db );
   ~KWMailMergeConfigDialog();
protected:
    TQPushButton *edit;
    TQPushButton *create;
    TQPushButton *open;
    TQPushButton *preview;
    TQPushButton *document;
    KWMailMergeDataBase *db_;
    void enableDisableEdit();
    void doNewActions();

protected slots:
    void slotEditClicked();
    void slotCreateClicked();
    void slotOpenClicked();
    void slotPreviewClicked();
    void slotDocumentClicked();
};

/******************************************************************
 *
 * Class: KWMailMergeVariableInsertDia
 *
 ******************************************************************/

class KWMailMergeVariableInsertDia : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KWMailMergeVariableInsertDia( TQWidget *parent, KWMailMergeDataBase *db );
    TQString getName() const; // ### unused, can we remove this?

  protected slots:
    void slotSelectionChanged();

  private:
    KWMailMergeDataBase *m_db;

  protected:
    TQListBox *names;
};

#endif
