/* This file is part of the KDE project
   Copyright (C)  2001 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kwconfig__
#define __kwconfig__

#include <kdialogbase.h>

namespace KFormula {
    class ConfigurePage;
}

class KWView;
class TQCheckBox;
class KIntNumInput;
class KoUnitDoubleSpinBox;
class KConfig;
class TQComboBox;
class KIntNumInput;
class KCommand;
class KWDocument;
class KListView;
class TQVGroupBox;
class TQLabel;

namespace KSpell2 {
    class ConfigWidget;
}

class ConfigureSpellPage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigureSpellPage( KWView *view, TQVBox *box, char *name = 0 );
    void apply();
    void slotDefault();
private:
    KWView* m_pView;
    KConfig* config;
    KSpell2::ConfigWidget *m_spellConfigWidget;
};

class ConfigureInterfacePage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigureInterfacePage( KWView *view, TQVBox *box, char *name = 0 );
    void apply();
    void slotDefault();
    void setUnit( KoUnit::Unit unit );

signals:
    // For KWConfig
    void unitChanged( int );
private:
    KWView* m_pView;
    KConfig* config;
    TQComboBox *m_unitCombo;
    KoUnitDoubleSpinBox* gridX,*gridY;
    KoUnitDoubleSpinBox* indent;
    KIntNumInput* recentFiles;
    TQCheckBox *showStatusBar, *showScrollBar, *pgUpDownMovesCaret;
    int oldNbRecentFiles;
    KIntNumInput *m_nbPagePerRow;
};

class ConfigureMiscPage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigureMiscPage( KWView *view, TQVBox *box, char *name = 0 );
    KCommand* apply();
    void slotDefault();
    void setUnit( KoUnit::Unit unit );
private:
    KWView* m_pView;
    KConfig* config;
    KIntNumInput* m_undoRedoLimit;
    int m_oldNbRedo;
    bool m_oldFormattingEndParag, m_oldFormattingSpace, m_oldFormattingTabs, m_oldFormattingBreak;
    TQCheckBox* m_displayLink, *m_displayComment, *m_underlineLink, *m_displayFieldCode;
    TQCheckBox* m_cbViewFormattingEndParag, *m_cbViewFormattingSpace;
    TQCheckBox* m_cbViewFormattingTabs, *m_cbViewFormattingBreak;
};

class ConfigureDefaultDocPage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigureDefaultDocPage( KWView *view, TQVBox *box, char *name = 0 );
    ~ConfigureDefaultDocPage();
    KCommand* apply();
    void slotDefault();
    void setUnit( KoUnit::Unit unit );
public slots:
    void selectNewDefaultFont();
private:
    KWView* m_pView;
    KConfig* config;
    TQFont *font;
    TQLabel *fontName;
    TQLabel *tabStop;

    KoUnitDoubleSpinBox* m_columnSpacing;

    KIntNumInput* autoSave;
    int oldAutoSaveValue;
    double m_oldTabStopWidth;

    int m_oldStartingPage;
    bool m_oldBackupFile;
    KIntNumInput* m_variableNumberOffset;
    KoUnitDoubleSpinBox *m_tabStopWidth;
    TQCheckBox *m_cursorInProtectedArea;
    TQCheckBox *m_createBackupFile;
//     TQCheckBox *m_directInsertCursor;
    TQCheckBox *m_autoHyphenation;
    TQComboBox *m_globalLanguage;
    TQString m_oldLanguage;
    bool m_oldHyphenation;
};

class ConfigurePathPage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigurePathPage( KWView *view, TQVBox *box, char *name = 0 );
    void slotDefault();
    void apply();
private slots:
    void slotModifyPath();
    void slotSelectionChanged(TQListViewItem *);
private:
    KWView* m_pView;
    KConfig* config;
    KListView* m_pPathView;
    TQPushButton *m_modifyPath;
};

class ConfigureTTSPage : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    ConfigureTTSPage( KWView *view, TQVBox *box, char *name = 0 );
    void slotDefault();
    void apply();
private slots:
    void screenReaderOptionChanged();
private:
    KConfig* config;
    TQCheckBox* m_cbSpeakPointerWidget;
    TQCheckBox* m_cbSpeakFocusWidget;
    TQVGroupBox* m_gbScreenReaderOptions;
    TQCheckBox* m_cbSpeakTooltips;
    TQCheckBox* m_cbSpeakWhatsThis;
    TQCheckBox* m_cbSpeakDisabled;
    TQCheckBox* m_cbSpeakAccelerators;
    TQLabel* m_lblAcceleratorPrefix;
    TQLineEdit* m_leAcceleratorPrefixWord;
    KIntNumInput* m_iniPollingInterval;
};

class KWConfig : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    enum { KW_KSPELL=1,KP_INTERFACE=2,KP_MISC=4, KP_DOCUMENT=8, KP_FORMULA=16, KP_PATH = 32};
    KWConfig( KWView* parent );
    void openPage(int flags);
public slots:
    void slotApply();
    void slotDefault();
    void unitChanged( int );
private:
    ConfigureSpellPage *m_spellPage;
    ConfigureInterfacePage *m_interfacePage;
    ConfigureMiscPage *m_miscPage;
    ConfigureDefaultDocPage *m_defaultDocPage;
    KFormula::ConfigurePage *m_formulaPage;
    ConfigurePathPage *m_pathPage;
    ConfigureTTSPage *m_ttsPage;
    KWDocument *m_doc;
};



#endif
