/* This file is part of the KDE project
  Copyright (C) 2002-2004 Alexander Dymo <adymo@mksat.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef VIEW_H
#define VIEW_H

#include <tqcanvas.h>
#include <tqpainter.h>
#include <tqptrlist.h>

#include <koproperty/property.h>

class KuDesignerPlugin;

class TQMouseEvent;
class TQCanvasItemList;

namespace KoProperty
{
class Buffer;
}

using namespace KoProperty;

namespace Kudesigner
{

class ReportItem;
class Box;
class Canvas;
class Band;

class SelectionRect: public TQCanvasRectangle
{
public:
    SelectionRect( int x, int y, int width, int height, Canvas *canvas ) :
            TQCanvasRectangle( x, y, width, height, ( TQCanvas* ) canvas )
    {}

    virtual void draw( TQPainter & painter );
};

class View: public TQCanvasView
{
    Q_OBJECT
  TQ_OBJECT
public:
    View( Canvas *canvas, TQWidget *parent, const char *name = 0, WFlags f = 0 );

    int itemToInsert;

    enum RequestType {RequestNone = 0, RequestProps, RequestDelete};

    void setRequest( RequestType r );
    void clearRequest();
    bool requested();

    void finishSelection();

    void setPlugin( KuDesignerPlugin *plugin );

    void setCanvas( Canvas *canvas );

protected:
    void contentsMousePressEvent( TQMouseEvent* );
    void contentsMouseReleaseEvent( TQMouseEvent* );
    void contentsMouseMoveEvent( TQMouseEvent* );
    void contentsMouseDoubleClickEvent( TQMouseEvent * );

    void contentsDragEnterEvent ( TQDragEnterEvent * );
    void contentsDragMoveEvent ( TQDragMoveEvent * );
    //    void contentsDragLeaveEvent ( TQDragLeaveEvent * );
    //    void contentsDropEvent ( TQDropEvent * );
    void keyPressEvent( TQKeyEvent * );

    void startMoveOrResizeOrSelectItem( TQCanvasItemList &l, TQMouseEvent *e, TQPoint &p );
    bool startResizing( TQMouseEvent *e, TQPoint &p );
    void placeItem( TQCanvasItemList &l, TQMouseEvent *e );
    void editItem( TQCanvasItemList &l );
    void deleteItem( TQCanvasItemList &l );
    void selectItemFromList( TQCanvasItemList &l );

    void stickToGrid( double &x, double &y );
    void stickDimToGrid( double x, double y, double &X, double &Y );

private:
    Buffer *selectionBuf;

    ReportItem *moving;
    TQPoint moving_start;
    double moving_offsetY;
    double moving_offsetX;
    TQRect resizing_constraint;
    TQSize resizing_minSize;
    int resizing_type;
    class Box *resizing;
    bool selectionStarted;

    KuDesignerPlugin *m_plugin;

    SelectionRect *selectionRect;

    RequestType request;

    Canvas *m_canvas;

    void fixMinValues( double &pos, double minv, double &offset );
    void fixMaxValues( double &pos, double size, double maxv, double &offset );

signals:  // Signals
    /** Emitted when user clicks on the canvas, so a button
    or a menu item assosiated with the selected item should
    be unchecked. */
    void selectedActionProcessed();
    void selectedEditActionProcessed();
    void modificationPerformed();

    /** Emitted when selection is made, so that property editor can display properties
        for the selected items. */
    void selectionMade( Buffer *buf );
    void selectionClear();
    void changed();

    void itemPlaced( int x, int y, int band, int bandLevel );

public slots:
    void updateProperty();

    void selectItem();
    void setGridSize( int size );
};

}

#endif
