#ifndef KSPREAD_EVENTS
#define KSPREAD_EVENTS

#include <tqevent.h>
#include <tqrect.h>
#include <tqstring.h>

#include <string.h>

#include <kparts/event.h>
#include <koffice_export.h>

#include "region.h"
namespace KSpread
{

class KSPREAD_EXPORT SelectionChanged : public KParts::Event
{
public:
    SelectionChanged( const Region&, const TQString& sheet );
    ~SelectionChanged();

    Region region() const { return m_region; }
    TQString sheet() const { return m_sheet; }

    static bool test( const TQEvent* e ) { return KParts::Event::test( e, s_strSelectionChanged ); }

private:
    static const char *s_strSelectionChanged;
    Region m_region;
    TQString m_sheet;
};

} // namespace KSpread

#endif
