/* This file is part of the KDE project
   Copyright (C) 2006 Robert Knight <robertknight@gmail.com>
             (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2002 Ariya Hidayat <ariya@kde.org>
             (C) 2002 John Dailey <dailey@vt.edu>
             (C) 2002 Werner Trobin <trobin@kde.org>
             (C) 2001-2002 Philipp Mueller <philipp.mueller@gmx.de>
             (C) 1999-2002 Laurent Montel <montel@kde.org>
             (C) 2000 David Faure <faure@kde.org>
             (C) 1998-2000 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_sort__
#define __kspread_dlg_sort__


#include <kdialogbase.h>
#include <tqstringlist.h>

class TQCheckBox;
class TQComboBox;
class TQLabel;
class TQLineEdit;
class TQPushButton;
class TQRadioButton;
class TQTabWidget;
class TQWidget;

namespace KSpread
{
class Sheet;
class View;

class SortDialog : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT

 public:
  enum Orientation
  {
    SortColumns=0,
    SortRows=1
  };
  
  SortDialog( View * parent, const char * name = 0,
                  bool modal = false );
  ~SortDialog();
 
 protected:
    Orientation guessDataOrientation();
    TQRect       sourceArea();
 
 private slots:
  void sortKey2textChanged( int );
  void useCustomListsStateChanged( int );
  void firstRowHeaderChanged( int );
  virtual void slotOk();
  void slotOrientationChanged(int id);

 private:
  void init();

  View  * m_pView;

  TQStringList    m_listColumn;
  TQStringList    m_listRow;

  TQWidget      * m_page1;
  TQWidget      * m_page2;

  TQTabWidget   * m_tabWidget;

  TQComboBox    * m_sortKey1;
  TQComboBox    * m_sortOrder1;
  TQComboBox    * m_sortKey2;
  TQComboBox    * m_sortOrder2;
  TQComboBox    * m_sortKey3;
  TQComboBox    * m_sortOrder3;

  TQCheckBox    * m_useCustomLists;
  TQComboBox    * m_customList;

  TQRadioButton * m_sortColumn;
  TQRadioButton * m_sortRow;

  TQCheckBox    * m_copyLayout;
  TQCheckBox    * m_firstRowOrColHeader;
  TQCheckBox    * m_respectCase;

  /*TQComboBox    * m_outputSheet;
  TQLineEdit    * m_outputCell;*/
};

} // namespace KSpread

#endif
