/* This file is part of the KDE project
   Copyright (C) 2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __CUSTOM_SLIDE_SHOW__
#define __CUSTOM_SLIDE_SHOW__

#include <kdialogbase.h>
#include <tqlistbox.h>
#include "global.h"

class TQLineEdit;
class TQPushButton;
class KPrDocument;
class TQToolButton;
class KPrView;
class KPrPage;

class KPrCustomSlideShowDia : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    KPrCustomSlideShowDia( KPrView* _view, KPrDocument *_doc, const char* name );
    ~KPrCustomSlideShowDia();
public slots:
    virtual void slotOk();
    void slotDoubleClicked(TQListBoxItem *);
    void slotTextClicked(TQListBoxItem*);
    void slotRemove();
    void slotAdd();
    void slotModify();
    void slotCopy();
    void slotTest();
    void slotPresentationFinished();

protected:
    void hideEvent( TQHideEvent* );

    void init();
    void updateButton();
    bool uniqueName( int val, const TQString & name ) const;

    TQListBox * list;
    TQPushButton* m_pRemove;
    TQPushButton* m_pAdd;
    TQPushButton* m_pModify;
    TQPushButton* m_pCopy;
    TQPushButton* m_pTest;
    bool m_bChanged;
    KPrDocument *m_doc;
    KPrView *m_view;
    CustomSlideShowMap m_customSlideShowMap;
    TQStringList listPageName;
};

class KPrCustomSlideShowItem : public TQListBoxText
{
public:
    KPrCustomSlideShowItem( TQListBox * listbox, KPrPage * page );
    KPrCustomSlideShowItem( KPrPage * page );
    KPrCustomSlideShowItem( TQListBox * listbox, KPrPage * page, TQListBoxItem * after );

    KPrPage * getPage() { return m_page; }
private:
    KPrPage * m_page;
};

class KPrDefineCustomSlideShow : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    KPrDefineCustomSlideShow( TQWidget* parent, TQStringList &_listNameSlideShow, const TQPtrList<KPrPage> &pages, const char *name = 0L);
    KPrDefineCustomSlideShow( TQWidget* parent, const TQString &_customName, TQStringList &_listNameSlideShow, 
                              const TQPtrList<KPrPage> &pages, TQValueList<KPrPage *> &customPages, const char* name = 0L );

    TQString customSlideShowName() const;
    TQValueList<KPrPage *> customSlides();

protected slots:
    void slotMoveUpSlide();
    void slotMoveDownSlide();
    void slotMoveRemoveSlide();
    void slotMoveInsertSlide();
    void slideNameChanged( const TQString & _name);
    void updateButton();
    virtual void slotOk();

protected:
    void init();
    TQStringList listNameCustomSlideShow;
    TQListBox *listSlide;
    TQListBox *listSlideShow;
    TQToolButton *m_insertSlide;
    TQToolButton *m_removeSlide;
    TQToolButton *m_moveUpSlide;
    TQToolButton *m_moveDownSlide;
    TQLineEdit *m_name;

};

#endif
