/* This file is part of the KDE project
   Copyright (C) 2004 - 2006 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kptintervaledit.h"
#include "intervalitem.h"

#include <tqpushbutton.h>
#include <tqcombobox.h>
#include <tqheader.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqdatetimeedit.h>
#include <tqdatetime.h>
#include <tqlistview.h>
#include <tqpair.h>
#include <tqdatetime.h>

#include <klocale.h>
#include <kdebug.h>

namespace KPlato
{

IntervalEdit::IntervalEdit(TQWidget *parent, const char *name)
    : IntervalEditImpl(parent)
{
    //kdDebug()<<k_funcinfo<<endl;

}

//--------------------------------------------
IntervalEditImpl::IntervalEditImpl(TQWidget *parent)
    : IntervalEditBase(parent) {

    intervalList->header()->setStretchEnabled(true);
    intervalList->setSortColumn(0);

    connect(bClear, TQT_SIGNAL(clicked()), TQT_SLOT(slotClearClicked()));
    connect(bAddInterval, TQT_SIGNAL(clicked()), TQT_SLOT(slotAddIntervalClicked()));
    connect(intervalList, TQT_SIGNAL(selectionChanged(TQListViewItem*)), TQT_SLOT(slotIntervalSelectionChanged(TQListViewItem*)));

}

void IntervalEditImpl::slotClearClicked() {
    bool c = intervalList->firstChild() != 0;
    intervalList->clear();
    if (c)
        emit changed();
}

void IntervalEditImpl::slotAddIntervalClicked() {
    new IntervalItem(intervalList, startTime->time(), endTime->time());
    emit changed();
}

void IntervalEditImpl::slotIntervalSelectionChanged(TQListViewItem *item) {
    IntervalItem *ii = dynamic_cast<IntervalItem *>(item);
    if (!ii)
        return;
    startTime->setTime(ii->interval().first);
    endTime->setTime(ii->interval().second);
}

TQPtrList<TQPair<TQTime, TQTime> > IntervalEditImpl::intervals() const {
    TQPtrList<TQPair<TQTime, TQTime> > l;
    TQListViewItem *i = intervalList->firstChild();
    for (; i; i = i->nextSibling()) {
        IntervalItem *item = dynamic_cast<IntervalItem*>(i);
        if (i)
            l.append(new TQPair<TQTime, TQTime>(item->interval().first, item->interval().second));
    }
    return l;
}

void IntervalEditImpl::setIntervals(const TQPtrList<TQPair<TQTime, TQTime> > &intervals) const {
    intervalList->clear();
    TQPtrListIterator<TQPair<TQTime, TQTime> > it =intervals;
    for (; it.current(); ++it) {
        new IntervalItem(intervalList, it.current()->first, it.current()->second);
    }
}

}  //KPlato namespace

#include "kptintervaledit.moc"
