/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_STACK_BAR_H
#define KIVIO_STACK_BAR_H

#include <tqdockwindow.h>
#include <tqptrdict.h>

namespace Kivio {
  class DragBarButton;
}

class KivioView;

using namespace Kivio;

class KivioStackBar : public TQDockWindow
{
  Q_OBJECT
  TQ_OBJECT
  public:
    KivioStackBar(KivioView* view, TQWidget* parent=0, const char* name=0);
    ~KivioStackBar();
  
    TQWidget* findPage(const TQString& name);
    TQWidget* findPage(DragBarButton*);
    void insertPage(TQWidget*, const TQString&);
    void removePage(TQWidget*);
    void deletePageAndButton(DragBarButton*);
    void showPage(TQWidget*);
  
    TQWidget* visiblePage() const { return m_visiblePage; }
    
    KivioView* view() const { return m_view; } 
  
  signals:
    void aboutToShow(TQWidget*);
    void beginDragPage(DragBarButton*);
    void finishDragPage(DragBarButton*);
    void deleteButton(DragBarButton*, TQWidget*, KivioStackBar*);
  
  protected:
    virtual void closeEvent(TQCloseEvent*);
  
  protected slots:
    void showButtonPage();
    void buttonBeginDrag();
    void buttonFinishDrag();
    void slotDeleteButton(DragBarButton*);
    void newPlace(TQDockWindow::Place place);
  
  private:
    TQPtrDict<TQWidget> m_data;
    TQWidget* m_visiblePage;
    KivioView* m_view;
};

#endif
