/* This file is part of the KDE project
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KLISTVIEWITEMTEMPLATE_H
#define KLISTVIEWITEMTEMPLATE_H

#include <klistview.h>

//! TQListViewItem class with ability for storing additional data member
template<class type>
class KListViewItemTemplate : public KListViewItem
{
	public:
		KListViewItemTemplate(type _data, TQListView *parent)
		 : KListViewItem(parent), data(_data) {}
		KListViewItemTemplate(type _data, TQListViewItem *parent)
		 : KListViewItem(parent), data(_data) {}
		KListViewItemTemplate(type _data, TQListView *parent, TQListViewItem *after)
		 : KListViewItem(parent, after), data(_data) {}
		KListViewItemTemplate(type _data, TQListViewItem *parent, TQListViewItem *after)
		 : KListViewItem(parent, after), data(_data) {}
		KListViewItemTemplate(type _data, TQListView *parent, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : KListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		KListViewItemTemplate(type _data, TQListViewItem *parent, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : KListViewItem(parent, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		KListViewItemTemplate(type _data, TQListView *parent, TQListViewItem *after, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		KListViewItemTemplate(type _data, TQListViewItem *parent, TQListViewItem *after, TQString label1, TQString label2=TQString(), TQString label3=TQString(), TQString label4=TQString(), TQString label5=TQString(), TQString label6=TQString(), TQString label7=TQString(), TQString label8=TQString())
		 : KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8), data(_data) {}
		
		type data;
};

#endif
