/* This file is part of the KDE project
   Copyright (C) 2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexidropdownbutton.h"

#include <kpopupmenu.h>
#include <kdebug.h>

#include <tqstyle.h>
#include <tqapplication.h>

KexiDropDownButton::KexiDropDownButton(TQWidget *parent)
 : TQToolButton(parent, "KexiDBImageBox::Button")
{
	setSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Expanding);
//! @todo get this from a KStyle
//	setFixedWidth(TQMAX(18, tqApp->globalStrut().width()));
	int fixedWidth;
	//hack
	if (qstricmp(style().name(),"thinkeramik")==0)
		fixedWidth = 18; //typical width as in "windows" style
	else
		fixedWidth = style().querySubControlMetrics( TQStyle::CC_ComboBox, 
			this, TQStyle::SC_ComboBoxArrow ).width();
	setFixedWidth( fixedWidth );
	setPopupDelay(10/*ms*/);
}

KexiDropDownButton::~KexiDropDownButton()
{
}

void KexiDropDownButton::drawButton( TQPainter *p )
{
	TQToolButton::drawButton(p);
	TQStyle::SFlags arrowFlags = TQStyle::Style_Default;
	if (isDown() || state()==On)
		arrowFlags |= TQStyle::Style_Down;
	if (isEnabled())
		arrowFlags |= TQStyle::Style_Enabled;
	style().tqdrawPrimitive(TQStyle::PE_ArrowDown, p,
		TQRect((width()-7)/2, height()-9, 7, 7), colorGroup(),
		arrowFlags, TQStyleOption() );
}

TQSize KexiDropDownButton::sizeHint () const
{
	return TQSize( fontMetrics().maxWidth() + 2*2, fontMetrics().height()*2 + 2*2 );
}

void KexiDropDownButton::keyPressEvent( TQKeyEvent * e ) 
{
	const int k = e->key();
	const bool dropDown = (e->state() == Qt::NoButton && (k==TQt::Key_Space || k==TQt::Key_Enter || k==TQt::Key_Return || k==TQt::Key_F2 || k==TQt::Key_F4))
	  || (e->state() == TQt::AltButton && k==TQt::Key_Down);
	if (dropDown) {
		e->accept();
		animateClick();
		TQMouseEvent me( TQEvent::MouseButtonPress, TQPoint(2,2), Qt::LeftButton, Qt::NoButton );
		TQApplication::sendEvent( this, &me );
		return;
	}
	TQToolButton::keyPressEvent(e);
}

#include "kexidropdownbutton.moc"
