/* This file is part of the KDE project
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXISMALLTOOLBUTTON_H
#define KEXISMALLTOOLBUTTON_H

#include <tqtoolbutton.h>
#include <kaction.h>

class TQIconSet;

//! A small tool button with icon and optional text
class KEXIEXTWIDGETS_EXPORT KexiSmallToolButton : public TQToolButton
{
	Q_OBJECT
  TQ_OBJECT

	public:
		KexiSmallToolButton(TQWidget* parent, const TQString& text, 
			const TQString& icon = TQString(), const char* name = 0);

		KexiSmallToolButton(TQWidget* parent, const TQString& text, 
			const TQIconSet& iconSet, const char* name = 0);

		KexiSmallToolButton(TQWidget* parent, KAction *action);
		
		virtual ~KexiSmallToolButton();

		void updateAction();

		virtual void setIconSet( const TQIconSet& iconSet );
		virtual void setIconSet( const TQString& icon );
		virtual void setTextLabel( const TQString & newLabel, bool tipToo );
		virtual void setTextLabel( const TQString & newLabel ) { setTextLabel(newLabel, false); }

	protected:
		void update(const TQString& text, const TQIconSet& iconSet, bool tipToo = false);
		void init();
		virtual void drawButton( TQPainter *_painter );

		TQGuardedPtr<KAction> m_action;
};

#endif
