/* This file is part of the KDE project
   Copyright (C) 2003 Lucijan Busch <lucijan@kde.org>
   Copyright (C) 2004 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIQUERYDESIGNERSQLHISTORY_H
#define KEXIQUERYDESIGNERSQLHISTORY_H

#include <tqscrollview.h>
#include <tqdatetime.h>
#include <tqptrlist.h>
#include <tqmap.h>
#include <tqsimplerichtext.h>

class TQSimpleRichText;
class KPopupMenu;

class HistoryEntry
{
	public:
		HistoryEntry(bool success, const TQTime &time, const TQString &statement, /*int y,*/ const TQString &error = TQString());
		~HistoryEntry();

		TQRect	geometry(int y, int width, TQFontMetrics f);
		void	drawItem(TQPainter *p, int width, const TQColorGroup &cg);

		void	setSelected(bool selected, const TQColorGroup &cg);
		bool	isSelected() const { return m_selected; }
		void	highlight(const TQColorGroup &selected);

		TQString	statement() { return m_statement; }
		void updateTime(const TQTime &execTime);

	private:
		bool	m_succeed;
		TQTime	m_execTime;
		TQString	m_statement;
		TQString m_error;
		TQSimpleRichText	*m_formated;

		int	m_y;
		bool	m_selected;
};

typedef TQPtrList<HistoryEntry> History;

class KexiQueryDesignerSQLHistory : public TQScrollView
{
	Q_OBJECT
  TQ_OBJECT

	public:
		KexiQueryDesignerSQLHistory(TQWidget *parent, const char *name=0);
		virtual ~KexiQueryDesignerSQLHistory();

		KPopupMenu* popupMenu() const;

//		void		contextMenu(const TQPoint &pos, HistoryEntry *e);

		void setHistory(History *h);

		TQString selectedStatement() const;

	public slots:
		void addEvent(const TQString& q, bool s, const TQString &error);

		void slotToClipboard();
		void slotEdit();

		void clear();

//		HistoryItem	itemAt(int y);

	protected:
		void addEntry(HistoryEntry *e);
		virtual void drawContents(TQPainter *p, int cx, int cy, int cw, int ch);
		virtual void contentsMousePressEvent(TQMouseEvent * e);
		virtual void contentsMouseDoubleClickEvent(TQMouseEvent * e);

	signals:
		void editRequested(const TQString &text);
		void currentItemDoubleClicked();

	private:
		History *m_history;
		HistoryEntry *m_selected;
		KPopupMenu *m_popup;
};

#endif
