/* This file is part of the KDE project
   Copyright (C) 2005 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2005 Christian Nitschkowski <segfault_ii@web.de>
   Copyright (C) 2005-2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDBAUTOFIELD_H
#define KEXIDBAUTOFIELD_H

#include <tqwidget.h>
#include <kexidb/field.h>
#include <formeditor/container.h>
#include <formeditor/widgetwithsubpropertiesinterface.h>
#include "kexiformdataiteminterface.h"

class TQBoxLayout;
class TQLabel;

//! Universal "Auto Field" widget for Kexi forms
/*! It acts as a container for most data-aware widgets. */
class KEXIFORMUTILS_EXPORT KexiDBAutoField : 
	public TQWidget,
	public KexiFormDataItemInterface,
	public KFormDesigner::DesignTimeDynamicChildWidgetHandler,
	public KFormDesigner::WidgetWithSubpropertiesInterface
{
	Q_OBJECT
  TQ_OBJECT
//'caption' is uncovered now	TQ_PROPERTY(TQString labelCaption READ caption WRITE setCaption DESIGNABLE true)
	TQ_OVERRIDE(TQString caption READ caption WRITE setCaption DESIGNABLE true)
	TQ_OVERRIDE(TQColor paletteForegroundColor READ paletteForegroundColor WRITE setPaletteForegroundColor DESIGNABLE true RESET unsetPalette)
	TQ_OVERRIDE(TQColor paletteBackgroundColor READ paletteBackgroundColor WRITE setPaletteBackgroundColor DESIGNABLE true RESET unsetPalette)
	TQ_PROPERTY(TQColor foregroundLabelColor READ foregroundLabelColor WRITE setForegroundLabelColor DESIGNABLE true RESET unsetPalette)
	TQ_PROPERTY(TQColor backgroundLabelColor READ backgroundLabelColor WRITE setBackgroundLabelColor DESIGNABLE true RESET unsetPalette)
	TQ_PROPERTY(bool autoCaption READ hasAutoCaption WRITE setAutoCaption DESIGNABLE true)
	TQ_PROPERTY(TQString dataSource READ dataSource WRITE setDataSource DESIGNABLE true)
	TQ_PROPERTY(TQCString dataSourceMimeType READ dataSourceMimeType WRITE setDataSourceMimeType DESIGNABLE true)
	TQ_PROPERTY( bool readOnly READ isReadOnly WRITE setReadOnly )
	TQ_PROPERTY(LabelPosition labelPosition READ labelPosition WRITE setLabelPosition DESIGNABLE true)
	TQ_PROPERTY(WidgetType widgetType READ widgetType WRITE setWidgetType DESIGNABLE true)
	/*internal, for design time only*/
	TQ_PROPERTY(int fieldTypeInternal READ fieldTypeInternal WRITE setFieldTypeInternal DESIGNABLE true STORED false)
	TQ_PROPERTY(TQString fieldCaptionInternal READ fieldCaptionInternal WRITE setFieldCaptionInternal DESIGNABLE true STORED false)
	Q_ENUMS( WidgetType LabelPosition )

	public:
		enum WidgetType { Auto = 100, Text, Integer, Double, Boolean, Date, Time, DateTime,
			MultiLineText, ComboBox, Image };
		enum LabelPosition { Left = 300, Top, NoLabel };

		KexiDBAutoField(const TQString &text, WidgetType type, LabelPosition pos, 
			TQWidget *parent = 0, const char *name = 0, bool designMode = true);
		KexiDBAutoField(TQWidget *parent = 0, const char *name = 0, bool designMode = true,
			LabelPosition pos = Left);

		virtual ~KexiDBAutoField();

		inline TQString dataSource() const { return KexiFormDataItemInterface::dataSource(); }
		inline TQCString dataSourceMimeType() const { return KexiFormDataItemInterface::dataSourceMimeType(); }
		virtual void setDataSource( const TQString &ds );
		virtual void setDataSourceMimeType(const TQCString &ds) { KexiFormDataItemInterface::setDataSourceMimeType(ds); }
		virtual void setColumnInfo(KexiDB::QueryColumnInfo* cinfo);

		virtual void setInvalidState(const TQString& text);
		virtual bool isReadOnly() const;
		virtual void setReadOnly( bool readOnly );

		virtual TQVariant value();
		virtual bool valueIsNull();
		virtual bool valueIsEmpty();
		virtual bool valueIsValid();
		virtual bool valueChanged();
		virtual void clear();

		//! Reimpelmented to also install \a listenter for internal editor
		virtual void installListener(KexiDataItemChangesListener* listener);

		WidgetType widgetType() const;
		void setWidgetType(WidgetType type);

		LabelPosition labelPosition() const;
		virtual void setLabelPosition(LabelPosition position);

		TQString caption() const;
		void setCaption(const TQString &caption);

		bool hasAutoCaption() const;
		void setAutoCaption(bool autoCaption);

		/*! If \a displayDefaultValue is true, the value set by KexiDataItemInterface::setValue() 
		 is displayed in a special way. Used by KexiFormDataProvider::fillDataItems(). 
		 \a widget is equal to 'this'.
		 Reimplemented after KexiFormDataItemInterface. */
		virtual void setDisplayDefaultValue(TQWidget* widget, bool displayDefaultValue);

		TQWidget* editor() const;
		TQLabel* label() const;

		virtual bool cursorAtStart();
		virtual bool cursorAtEnd();

		static WidgetType widgetTypeForFieldType(KexiDB::Field::Type type);

		/*! On design time it is not possible to pass a reference to KexiDB::Field object
		 so we're just providing field type. Only used when widget type is Auto.
		 @internal */
		void setFieldTypeInternal(int kexiDBFieldType);

		/*! On design time it is not possible to pass a reference to KexiDB::Field object
		 so we're just providing field caption. Only used when widget type is Auto.
		 @internal */
		void setFieldCaptionInternal(const TQString& text);

		/*! @internal */
		int fieldTypeInternal() const;

		/*! @internal */
		TQString fieldCaptionInternal() const;

		virtual TQSize sizeHint() const;
		virtual void setFocusPolicy ( TQ_FocusPolicy policy );

		//! Reimplemented to return internal editor's color.
		const TQColor & paletteForegroundColor() const;

		//! Reimplemented to set internal editor's color.
		void setPaletteForegroundColor( const TQColor & color );

		//! Reimplemented to return internal editor's color.
		const TQColor & paletteBackgroundColor() const;

		//! Reimplemented to set internal editor's color.
		virtual void setPaletteBackgroundColor( const TQColor & color );

		//! \return label's foreground color
		const TQColor & foregroundLabelColor() const;

		//! Sets label's foreground color
		virtual void setForegroundLabelColor( const TQColor & color );

		//! \return label's background color
		const TQColor & backgroundLabelColor() const;

		//! Sets label's background color
		virtual void setBackgroundLabelColor( const TQColor & color );

		//! Reimplemented to accept subproperties. @see KFormDesigner::WidgetWithSubpropertiesInterface
		virtual TQVariant property( const char * name ) const;

		//! Reimplemented to accept subproperties. @see KFormDesigner::WidgetWithSubpropertiesInterface
		virtual bool setProperty( const char * name, const TQVariant & value );

		/*! Called by the top-level form on key press event to consume widget-specific shortcuts. */
		virtual bool keyPressed(TQKeyEvent *ke);

	public slots:
		virtual void unsetPalette();

	protected slots:
//		void slotValueChanged();
		virtual void paletteChange( const TQPalette& oldPal );

		//! Implemented for KexiDataItemInterface
		virtual void moveCursorToEnd();

		//! Implemented for KexiDataItemInterface
		virtual void moveCursorToStart();

		//! Implemented for KexiDataItemInterface
		virtual void selectAll();

	protected:
		virtual void setValueInternal(const TQVariant&add, bool removeOld);
		void init(const TQString &text, WidgetType type, LabelPosition pos);
		virtual void createEditor();
		void changeText(const TQString &text, bool beautify = true);
//		virtual void paintEvent( TQPaintEvent* pe );
		void updateInformationAboutUnboundField();

		//! internal editor can be created too late, so certain properties should be copied
		void copyPropertiesToEditor();

		virtual bool eventFilter( TQObject *o, TQEvent *e );

		//! Used by @ref setLabelPositionInternal(LabelPosition)
		void setLabelPositionInternal(LabelPosition position, bool noLabel);

		//! Used by KexiDBAutoField::setColumnInfo() and KexiDBComboBox::setColumnInfo()
		void setColumnInfoInternal(KexiDB::QueryColumnInfo* cinfo, KexiDB::QueryColumnInfo* visibleColumnInfo);

	private:
		class Private;
		Private *d;
};

#endif
