/* This file is part of the KDE project
   Copyright (C) 2004 Lucijan Busch <lucijan@kde.org>
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIFORMPART_H
#define KEXIFORMPART_H

#include <tqdom.h>
#include <tqcstring.h>

#include <kexi.h>
#include <kexipart.h>
#include <kexidialogbase.h>
#include <kexiblobbuffer.h>

namespace KFormDesigner
{
	class WidgetLibrary;
	class FormManager;
	class Form;
}

namespace KexiDB
{
	class FieldList;
}

class KexiDataSourcePage;

//! Kexi Form Plugin
/*! It just creates a \ref KexiFormView. See there for most of code. */
class KEXIFORMUTILS_EXPORT KexiFormPart : public KexiPart::Part
{
	Q_OBJECT
  TQ_OBJECT

	public:
		KexiFormPart(TQObject *parent, const char *name, const TQStringList &);
		virtual ~KexiFormPart();

		//! \return a pointer to Forms Widget Library.
		static KFormDesigner::WidgetLibrary* library();

		KexiDataSourcePage* dataSourcePage() const;

		void generateForm(KexiDB::FieldList *list, TQDomDocument &domDoc);

		class TempData : public KexiDialogTempData
		{
			public:
				TempData(TQObject* parent);
				~TempData();
				TQGuardedPtr<KFormDesigner::Form> form;
				TQGuardedPtr<KFormDesigner::Form> previewForm;
				TQString tempForm;
				TQPoint scrollViewContentsPos; //!< to preserve contents pos after switching to other view
				int resizeMode; //!< form's window's resize mode -one of KexiFormView::ResizeMode items
				//! Used in KexiFormView::setUnsavedLocalBLOBs()
				TQMap<TQWidget*, KexiBLOBBuffer::Id_t> unsavedLocalBLOBs;
				//! Used when loading a form from (temporary) XML in Data View 
				//! to get unsaved blobs collected at design mode.
				TQMap<TQCString, KexiBLOBBuffer::Id_t> unsavedLocalBLOBsByName;
		};

		virtual TQString i18nMessage(const TQCString& englishMessage, 
			KexiDialogBase* dlg) const;

	protected:
		virtual KexiDialogTempData* createTempData(KexiDialogBase* dialog);

		virtual KexiViewBase* createView(TQWidget *parent, KexiDialogBase* dialog,
			KexiPart::Item &item, int viewMode = Kexi::DataViewMode, TQMap<TQString,TQString>* staticObjectArgs = 0);

		virtual void initPartActions();
		virtual void initInstanceActions();
		virtual void setupCustomPropertyPanelTabs(KTabWidget *tab, KexiMainWindow* mainWin);

		static KFormDesigner::WidgetLibrary* static_formsLibrary;

	protected slots:
		void slotAutoTabStopsSet(KFormDesigner::Form *form, bool set);
		void slotAssignAction();
		void slotPropertyChanged(TQWidget *widget, const TQCString &name, const TQVariant &value);
		void slotWidgetCreatedByFormsLibrary(TQWidget* widget);

	private:
		class Private;
		Private* d;
};

#endif

