/* This file is part of the KDE project
   Copyright (C) 2003-2004 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDB_DRIVER_SQLITE_H
#define KEXIDB_DRIVER_SQLITE_H

#include <tqstringlist.h>

#include <kexidb/driver.h>

namespace KexiDB
{

class Connection;
class DriverManager;
class SQLiteDriverPrivate;

//! SQLite database driver.
class SQLiteDriver : public Driver
{
	Q_OBJECT
  TQ_OBJECT
	KEXIDB_DRIVER

	public:
		SQLiteDriver( TQObject *parent, const char *name, const TQStringList &args = TQStringList() );
		virtual ~SQLiteDriver();

		/*! \return true if \a n is a system object name; 
			for this driver any object with name prefixed with "sqlite_" 
			is considered as system object.
		*/
		virtual bool isSystemObjectName( const TQString& n ) const;

		/*! \return false for this driver. */
		virtual bool isSystemDatabaseName( const TQString& ) const { return false; }

		//! Escape a string for use as a value
		virtual TQString escapeString(const TQString& str) const;
		virtual TQCString escapeString(const TQCString& str) const;

		//! Escape BLOB value \a array
		virtual TQString escapeBLOB(const TQByteArray& array) const;

	protected:
		virtual TQString drv_escapeIdentifier( const TQString& str) const;
		virtual TQCString drv_escapeIdentifier( const TQCString& str) const;
		virtual Connection *drv_createConnection( ConnectionData &conn_data );
		virtual AdminTools* drv_createAdminTools() const;

		/*! \return true if \a n is a system field name; 
			for this driver fields with name equal "_ROWID_" 
			is considered as system field.
		*/
		virtual bool drv_isSystemFieldName( const TQString& n ) const;

	SQLiteDriverPrivate *dp;
	
	private:
		static const char *keywords[];

};

}

#endif

