/* This file is part of the KDE project
Copyright (C) 2002   Lucijan Busch <lucijan@gmx.at>
Daniel Molkentin <molkentin@kde.org>
Copyright (C) 2003   Joseph Wenninger<jowenn@kde.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef MYSQLDB_H
#define MYSQLDB_H

#include <kexidb/driver.h>

namespace KexiDB {

//! MySQL database driver.
class MySqlDriver : public Driver
{
	Q_OBJECT
  TQ_OBJECT
	KEXIDB_DRIVER

	public:
		MySqlDriver(TQObject *parent, const char *name, const TQStringList &args=TQStringList());
		virtual ~MySqlDriver();
		
		virtual bool isSystemDatabaseName( const TQString &n ) const;

		//! Escape a string for use as a value
		virtual TQString escapeString(const TQString& str) const;
		virtual TQCString escapeString(const TQCString& str) const;

		//! Escape BLOB value \a array
		virtual TQString escapeBLOB(const TQByteArray& array) const;

	protected:
		virtual TQString drv_escapeIdentifier( const TQString& str) const;
		virtual TQCString drv_escapeIdentifier( const TQCString& str) const;
		virtual Connection *drv_createConnection( ConnectionData &conn_data );
		virtual bool drv_isSystemFieldName( const TQString& n ) const;
	
	private:
		static const char *keywords[];
};
}

#endif
