/* This file is part of the KDE project
   Copyright (C) 2003 Lucijan Busch <lucijan@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <sys/types.h>
#include <unistd.h>

#include <tqdom.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqregexp.h>

#include <kglobal.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <kexidb/connectiondata.h>
#include <kexidb/drivermanager.h>
#include "kexiprojectconnectiondata.h"

KexiProjectConnectionData::KexiProjectConnectionData(): KexiDB::ConnectionData()
{
}

KexiProjectConnectionData::KexiProjectConnectionData(const TQString& driverName, const TQString& databaseName, const TQString &host, 
		unsigned short int rport, const TQString& user, const TQString &pass, const TQString& file):KexiDB::ConnectionData()
{
	m_driverName=driverName;
	m_databaseName=databaseName;
	hostName=host;
	port=rport;
	userName=user;
	password=pass;
	setFileName(file);
}

KexiProjectConnectionData::KexiProjectConnectionData(const TQString &driverName, const TQString &fileName)
 : KexiDB::ConnectionData()
{
	m_driverName=driverName;
	setFileName(fileName);
}

const TQString &
KexiProjectConnectionData::generateTmpName()
{
	return TQString();
}

KexiProjectConnectionData*
KexiProjectConnectionData::loadInfo(TQDomElement &rootElement)
{
	TQDomElement engineElement = rootElement.namedItem("engine").toElement();
	TQDomElement hostElement = rootElement.namedItem("host").toElement();
	TQDomElement portElement = rootElement.namedItem("port").toElement();
	TQDomElement nameElement = rootElement.namedItem("name").toElement();
	TQDomElement userElement = rootElement.namedItem("user").toElement();
	TQDomElement passElement = rootElement.namedItem("password").toElement();
	TQDomElement persElement = rootElement.namedItem("persistant").toElement();
	TQDomElement encodingElement = rootElement.namedItem("encoding").toElement();

	KexiProjectConnectionData *tmp=new KexiProjectConnectionData(
		engineElement.text(), nameElement.text(),hostElement.text(),portElement.text().toInt(),
		userElement.text(),passElement.text(),"");	

	return tmp;
}

void    KexiProjectConnectionData::setDriverName(const TQString &driverName) {
	m_driverName=driverName;
}

void KexiProjectConnectionData::setDatabaseName(const TQString &databaseName) {
	m_databaseName=databaseName;
}

TQString KexiProjectConnectionData::driverName() const {
	return m_driverName;
}

TQString KexiProjectConnectionData::databaseName() const {
	return m_databaseName;
}


void
KexiProjectConnectionData::writeInfo(TQDomDocument &domDoc)
{
	TQDomElement connectionElement = domDoc.createElement("KexiDBConnection");
	domDoc.documentElement().appendChild(connectionElement);

//DB ENGINE
	TQDomElement engineElement = domDoc.createElement("engine");
	connectionElement.appendChild(engineElement);

	TQDomText tEngine = domDoc.createTextNode(m_driverName);
	engineElement.appendChild(tEngine);

//HOST
	TQDomElement hostElement = domDoc.createElement("host");
	connectionElement.appendChild(hostElement);

	TQDomText tHost = domDoc.createTextNode(hostName);
	hostElement.appendChild(tHost);

//DATABASE NAME
	TQDomElement nameElement = domDoc.createElement("name");
	connectionElement.appendChild(nameElement);

	TQDomText tName = domDoc.createTextNode(m_databaseName);
	nameElement.appendChild(tName);

//USER
	TQDomElement userElement = domDoc.createElement("user");
	connectionElement.appendChild(userElement);

	TQDomText tUser = domDoc.createTextNode(userName);
	userElement.appendChild(tUser);

//PASSWORD STUFF
	TQDomElement passElement = domDoc.createElement("password");
	connectionElement.appendChild(passElement);

	TQDomText tPass=domDoc.createTextNode(password);
	passElement.appendChild(tPass);

}



KexiProjectConnectionData::~KexiProjectConnectionData()
{
}
