
#include "kchartWizardSelectDataFormatPage.h"
#include "kchart_view.h"
#include "kchart_part.h"

#include <tqhbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqbuttongroup.h>
#include <tqvbuttongroup.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tqpainter.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdialog.h>

#include "kchart_params.h"

namespace KChart
{

KChartWizardSelectDataFormatPage::KChartWizardSelectDataFormatPage( TQWidget* parent,
                                                                        KChartPart* chart ) :
  TQWidget( parent ),
  m_chart( chart )
{
    TQGridLayout *grid1 = new TQGridLayout(this, 6, 1, KDialog::marginHint(),
					 KDialog::spacingHint());

    // The Data Area
    TQButtonGroup *gb1 = new TQVButtonGroup( i18n( "Data Area" ), this );

    TQHBox   *hbox = new TQHBox( gb1 );
    (void) new TQLabel( i18n("Area: "), hbox);
    m_dataArea = new TQLineEdit( hbox );
    grid1->addWidget(gb1, 0, 0);

    // The row/column as label checkboxes. 
    m_firstRowAsLabel = new TQCheckBox( i18n( "First row as label" ), gb1);
    m_firstColAsLabel = new TQCheckBox( i18n( "First column as label" ), gb1);

    // The Data Format button group
    TQButtonGroup *gb = new TQVButtonGroup( i18n( "Data Format" ), this );

    m_rowMajor = new TQRadioButton( i18n( "Data in rows" ), gb );
    m_rowMajor->resize( m_rowMajor->sizeHint() );

    m_colMajor = new TQRadioButton( i18n( "Data in columns" ), gb );
    m_colMajor->resize( m_colMajor->sizeHint() );

    grid1->addWidget(gb, 3, 0);

    TQLabel *lbl = new TQLabel( i18n( 
        "\n"
	"If the selected data area does not match the data you want,\n"
	"select the data now.\n"
	"\n"
	"Include cells that you want to use as row and column labels,\n"
	"if you want them in the chart.\n"
	), this);
    grid1->addWidget(lbl, 4, 0);

    grid1->setColStretch(5, 0);

    grid1->activate();

    // Enter the data into the widgets.
    if ( m_chart->params()->dataDirection() == KChartParams::DataColumns)
      m_colMajor->setChecked(true);
    else
      m_rowMajor->setChecked(true);

    m_dataArea->setText( m_chart->params()->dataArea() );
}


TQString KChartWizardSelectDataFormatPage::dataArea() const
{
    return m_dataArea->text();
}

void KChartWizardSelectDataFormatPage::setDataArea( const TQString &area )
{
    m_dataArea->setText( area );
}


void KChartWizardSelectDataFormatPage::apply()
{
    if (m_rowMajor->isChecked())
      m_chart->params()->setDataDirection( KChartParams::DataRows );
    else
      m_chart->params()->setDataDirection( KChartParams::DataColumns );

    m_chart->params()->setFirstRowAsLabel( m_firstRowAsLabel->isChecked() );
    m_chart->params()->setFirstColAsLabel( m_firstColAsLabel->isChecked() );

    m_chart->params()->setDataArea( m_dataArea->text() );
    // FIXME: Actually take use the new data area.
}


}  //KChart namespace

#include "kchartWizardSelectDataFormatPage.moc"
