/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kchartParameterPolarConfigPage.h"

#include "kchartParameterPolarConfigPage.moc"

#include <kapplication.h>
#include <klocale.h>
#include <kdebug.h>
#include <kdialog.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>
#include <tqvbuttongroup.h>
#include <tqwhatsthis.h>

#include "kchart_params.h"

namespace KChart
{

KChartParameterPolarConfigPage::KChartParameterPolarConfigPage( KChartParams* params,
                                                            TQWidget* parent ) :
    TQWidget( parent ),_params( params )
{
    TQVBoxLayout *grid1 = new TQVBoxLayout(this);
    TQVButtonGroup* gb = new TQVButtonGroup( i18n( "Parameter" ), this );
    grid1->addWidget(gb);

    polarMarker=new TQCheckBox(i18n("Polar marker"), gb);
    TQWhatsThis::add(polarMarker, i18n("If this is checked, the polar markers are shown; otherwise they are not."));
    showCircularLabel = new TQCheckBox(i18n("Show circular label"), gb);
    TQWhatsThis::add(showCircularLabel, i18n("Toggle the circular label display."));

    TQLabel *label = new TQLabel( i18n( "Zero degree position:" ), gb );
    angle = new TQSpinBox(-359, 359, 1, gb);
    TQWhatsThis::add(angle, i18n("Set the position for the X axis (horizontal) from -359 to 359. Default is 0."));

    label=new TQLabel(i18n("Line width:"), gb);
    lineWidth=new TQSpinBox(gb);
    TQWhatsThis::add(lineWidth, i18n("Set the width for the chart lines. 0 is default and is the thinnest."));

    grid1->activate();
}


void KChartParameterPolarConfigPage::init()
{
    polarMarker->setChecked(_params->polarMarker());
    angle->setValue( _params->polarZeroDegreePos() );
    showCircularLabel->setChecked(_params->polarRotateCircularLabels());
    lineWidth->setValue(_params->polarLineWidth());
}


void KChartParameterPolarConfigPage::apply()
{
    _params->setPolarZeroDegreePos(angle->value());
    _params->setPolarMarker(polarMarker->isChecked());
    _params->setPolarRotateCircularLabels(showCircularLabel->isChecked());
    _params->setPolarLineWidth(lineWidth->value());
}

}  //KChart namespace
