/* This file is part of the KDE project
   Copyright (C) 1999 Matthias Kalle Dalheimer <kalle@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KCHARTCOLORCONFIGPAGE_H__
#define __KCHARTCOLORCONFIGPAGE_H__


#include <tqwidget.h>
#include <kcolorbutton.h>

#include "koChart.h"
#include "kchartcolorarray.h"

class KListBox;


namespace KChart
{

class KChartParams;

// PENDING(kalle) Make this dynamic.
#define NUMDATACOLORS 6

class KChartColorConfigPage : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    KChartColorConfigPage( KChartParams* params, TQWidget* parent, KDChartTableData *dat );
    void apply();

    void setBackgroundColor( TQColor color );
    TQColor backgroundColor() const;
    void setGridColor( TQColor color );
    TQColor gridColor() const;
    void setLineColor( TQColor color );
    TQColor lineColor() const;
    void setXTitleColor( TQColor color );
    TQColor xTitleColor() const;
    void setYTitleColor( TQColor color );
    TQColor yTitleColor() const;
#if 0
    void setYTitle2Color( TQColor color );
    TQColor yTitle2Color() const;
#endif
    void setXLabelColor( TQColor color );
    TQColor xLabelColor() const;
    void setXLineColor( TQColor color );
    TQColor xLineColor() const;
    void setXZeroLineColor( TQColor color );
    TQColor xZeroLineColor() const;

    void setYLabelColor( TQColor color );
    TQColor yLabelColor() const;
    void setYLineColor( TQColor color );
    TQColor yLineColor() const;
    void setYZeroLineColor( TQColor color );
    TQColor yZeroLineColor() const;
#if 0
    void setYLabel2Color( TQColor color );
    TQColor yLabel2Color() const;
#endif
    /*void setEdgeColor( TQColor color );
    TQColor edgeColor() const;*/
/*     void setDataColor( uint dataset, TQColor color ); */
/*     TQColor dataColor( uint dataset ) const; */

private slots:
    void activeColorButton();
    void changeIndex( int );

private:
    void initDataColorList();

    KChartParams      *m_params;
    KDChartTableData  *m_data;

    KColorButton* _lineCB;
    KColorButton* _gridCB;
    KColorButton* _xtitleCB;
    KColorButton* _ytitleCB;
#if 0
    KColorButton* _ytitle2CB;
#endif
    KColorButton* _xlabelCB;
    KColorButton* _ylabelCB;
#if 0
    KColorButton* _ylabel2CB;
#endif
    KColorButton* _xlineCB;
    KColorButton* _ylineCB;
#if 0
    KColorButton* _yline2CB;
#endif
    KColorButton* _xzerolineCB;
    KColorButton* _yzerolineCB;
#if 0
    KColorButton* _yzeroline2CB;
#endif

//  KColorButton* _edgeCB;
//  KColorButton* _dataCB[NUMDATACOLORS];
    KListBox* _dataColorLB;
    KColorButton* _dataColorCB;
    KChartColorArray extColor;
    uint index;
};


inline void KChartColorConfigPage::setGridColor( TQColor color )
{
    _gridCB->setColor( color );
}


inline TQColor KChartColorConfigPage::gridColor() const
{
    return _gridCB->color();
}


inline void KChartColorConfigPage::setLineColor( TQColor color )
{
    _lineCB->setColor( color );
}


inline TQColor KChartColorConfigPage::lineColor() const
{
    return _lineCB->color();
}


inline void KChartColorConfigPage::setXTitleColor( TQColor color )
{
    _xtitleCB->setColor( color );
}


inline TQColor KChartColorConfigPage::xTitleColor() const
{
    return _xtitleCB->color();
}


inline void KChartColorConfigPage::setYTitleColor( TQColor color )
{
    _ytitleCB->setColor( color );
}


inline TQColor KChartColorConfigPage::yTitleColor() const
{
    return _ytitleCB->color();
}


#if 0
inline void KChartColorConfigPage::setYTitle2Color( TQColor color )
{
    _ytitle2CB->setColor( color );
}


inline TQColor KChartColorConfigPage::yTitle2Color() const
{
    return _ytitle2CB->color();
}
#endif

inline void KChartColorConfigPage::setXLabelColor( TQColor color )
{
    _xlabelCB->setColor( color );
}


inline TQColor KChartColorConfigPage::xLabelColor() const
{
    return _xlabelCB->color();
}


inline void KChartColorConfigPage::setYLabelColor( TQColor color )
{
    _ylabelCB->setColor( color );
}


inline TQColor KChartColorConfigPage::yLabelColor() const
{
    return _ylabelCB->color();
}


#if 0
inline void KChartColorConfigPage::setYLabel2Color( TQColor color )
{
    _ylabel2CB->setColor( color );
}
inline TQColor KChartColorConfigPage::yLabel2Color() const
{
    return _ylabel2CB->color();
}
#endif


inline void KChartColorConfigPage::setXLineColor( TQColor color )
{
    _xlineCB->setColor( color );
}
inline TQColor KChartColorConfigPage::xLineColor() const
{
    return _xlineCB->color();
}

inline void KChartColorConfigPage::setYLineColor( TQColor color )
{
    _ylineCB->setColor( color );
}
inline TQColor KChartColorConfigPage::yLineColor() const
{
    return _ylineCB->color();
}

#if 0
inline void KChartColorConfigPage::setYLine2Color( TQColor color )
{
    _yline2CB->setColor( color );
}
inline TQColor KChartColorConfigPage::yLine2Color() const
{
    return _yline2CB->color();
}
#endif


inline void KChartColorConfigPage::setXZeroLineColor( TQColor color )
{
    _xzerolineCB->setColor( color );
}
inline TQColor KChartColorConfigPage::xZeroLineColor() const
{
    return _xzerolineCB->color();
}

inline void KChartColorConfigPage::setYZeroLineColor( TQColor color )
{
    _yzerolineCB->setColor( color );
}
inline TQColor KChartColorConfigPage::yZeroLineColor() const
{
    return _yzerolineCB->color();
}

#if 0
inline void KChartColorConfigPage::setYZeroLine2Color( TQColor color )
{
    _yzeroline2CB->setColor( color );
}
inline TQColor KChartColorConfigPage::yZeroLine2Color() const
{
    return _yzeroline2CB->color();
}
#endif


/*inline void KChartColorConfigPage::setEdgeColor( TQColor color )
{
    _edgeCB->setColor( color );
}


inline TQColor KChartColorConfigPage::edgeColor() const
{
    return _edgeCB->color();
}*/

}  //KChart namespace

#endif
