/* This file is part of the KDE project
   Copyright (C) 2002 Robert JACOLIN <rjacolin@ifrance.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
   This file use code from koTemplateOpenDia for the method chooseSlot.
*/

#include <xsltexportdia.h>
#include <xsltproc.h>

#include <tqdir.h>
#include <tqcombobox.h>

#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdeversion.h>
#include <kstandarddirs.h>
#include <krecentdocument.h>
#include <ktempfile.h>
#include <kfiledialog.h>
#include <kdebug.h>
#include <KoFilterManager.h>
#include <KoStoreDevice.h>

/*#ifdef __FreeBSD__
#include <unistd.h>
#endif*/

/*
 *  Constructs a XSLTExportDia which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
XSLTExportDia::XSLTExportDia(KoStoreDevice* in, const TQCString &format, TQWidget* parent,  const char* name_, bool modal, WFlags fl )
    : XSLTDialog( parent, name_, modal, fl )
{
	int i = 0;
	_in = in;
	_format = format;
	setCaption(i18n("Export XSLT Configuration"));

	kapp->restoreOverrideCursor();

	/* Recent files */
	_config = new KConfig("xsltdialog");
	_config->setGroup( "XSLT export filter" );
	TQString value;
	while(i < 10)
	{
		value = _config->readPathEntry( TQString("Recent%1").arg(i) );
		kdDebug() << "recent : " << value << endl;
		if(!value.isEmpty())
		{
			_recentList.append( value );
			recentBox->insertItem(value);
		}
		else
			i = 10;
		i = i + 1;
	}

	/* Common xslt files box */
	TQString appName = (const char*) KGlobal::instance()->instanceName();
	kdDebug() << "app name = " << appName << endl;

	TQString filenames = TQString("xsltfilter") + TQDir::separator() + TQString("export") +
			TQDir::separator() + appName + TQDir::separator() + "*/*.xsl";
	TQStringList commonFilesList = KGlobal::dirs()->findAllResources("data", filenames, true);
	kdDebug() << "There are " << commonFilesList.size() << " entries like  " << filenames << endl;

	TQStringList tempList;
	TQString name;
	TQString file;

	for(TQStringList::Iterator it = commonFilesList.begin(); it != commonFilesList.end(); ++it)
	{
		tempList = TQStringList::split("/", (*it));
		file = tempList.last();
		tempList.pop_back();
		name = tempList.last();
		tempList.pop_back();
		kdDebug() << name << " " << file << endl;
		if(!_namesList.contains(name) && file == "main.xsl")
		{
			_filesList.append(file);
			_namesList.append(name);
			_dirsList.append(tempList.join("/"));
			kdDebug() << file << " get" << endl;
		}
	}

	xsltList->insertStringList(_namesList);
}

/*
 *  Destroys the object and frees any allocated resources
 */
XSLTExportDia::~XSLTExportDia()
{
    delete _config;
}

/**
 * Called when thecancel button is clicked.
 * Close the dialog box.
 */
void XSLTExportDia::cancelSlot()
{
	kdDebug() << "export cancelled" << endl;
	reject();
}

/**
 * Called when the choose button is clicked. A file dialog is open to allow to choose
 * the xslt to use.
 * Change the value of the current file.
 */
void XSLTExportDia::chooseSlot()
{

	/* Use dir from currently selected file */
    TQString dir = TQString();
    if ( _currentFile.isLocalFile() && TQFile::exists( _currentFile.path() ) )
        dir = TQFileInfo( _currentFile.path() ).absFilePath();

    KFileDialog *dialog = new KFileDialog(dir, TQString(), 0L, "file dialog", true);
    dialog->setCaption( i18n("Open Document") );
    dialog->setMimeFilter( KoFilterManager::mimeFilter( _format, KoFilterManager::Export ) );
    KURL u;

    if(dialog->exec() == TQDialog::Accepted)
    {
        u = dialog->selectedURL();
        KRecentDocument::add(dialog->selectedURL().url(), !dialog->selectedURL().isLocalFile());
    } else //revert state
    {
        //if (bEmpty) openEmpty();
        //if (bTemplates) openTemplate();
    }

    delete dialog;

    TQString filename = u.path();
    TQString url = u.url();
    bool local = u.isLocalFile();

    bool ok = !url.isEmpty();
    if (local) // additional checks for local files
        ok = ok && (TQFileInfo( filename ).isFile() ||
                    (TQFileInfo( filename ).isSymLink() &&
                     !TQFileInfo( filename ).readLink().isEmpty() &&
                     TQFileInfo( TQFileInfo( filename ).readLink() ).isFile() ) );

    if ( ok )
    {
        _currentFile = u;
        okSlot();
    }
}

/**
 * Called when the user clic on an element in the recent list.
 * Change the value of the current file.
 */
void XSLTExportDia::chooseRecentSlot()
{
	kdDebug() << "recent slot : " << recentBox->currentText() << endl;
	_currentFile = recentBox->currentText();
}

/**
 * Called when teh user clic on an element in the common list of xslt sheet.
 * Change the value of the current file.
 */
void XSLTExportDia::chooseCommonSlot()
{
	int num = xsltList->currentItem();
	_currentFile = TQDir::separator() + _dirsList[num] + TQDir::separator() +
			xsltList->currentText() + TQDir::separator() + _filesList[num];
	kdDebug() << "common slot : " << _currentFile.url() << endl;
}

/**
 * Called when the user clic on the ok button. The xslt sheet is put on the recent list which is
 * saved, then the xslt processor is called to export the document.
 */
void XSLTExportDia::okSlot()
{
	hide();
	if(_currentFile.url().isEmpty())
		return;
	kdDebug() << "XSLT FILTER --> BEGIN" << endl;
	TQString stylesheet = _currentFile.directory() + TQDir::separator() + _currentFile.fileName();

	/* Add the current file in the recent list if is not and save the list. */
	if(_recentList.contains(stylesheet) == 0)
	{
		kdDebug() << "Style sheet add to recent list" << endl;
		/* Remove the older stylesheet used */
		if(_recentList.size() >= 10)
			_recentList.pop_back();

		/* Add the new */
		_recentList.prepend(stylesheet);

		/* Save the new list */
		kdDebug() << "Recent list save " << _recentList.size() << " entrie(s)" << endl;
		int i = 0;
		while(_recentList.size() > 0)
		{
			kdDebug() << "save : " << _recentList.first() << endl;
#if KDE_IS_VERSION(3,1,3)
			_config->writePathEntry( TQString("Recent%1").arg(i), _recentList.first());
#else
			_config->writeEntry( TQString("Recent%1").arg(i), _recentList.first());
#endif
			_recentList.pop_front();
			i = i + 1;
		}
		/* Write config on disk */
		_config->sync();
	}

	/* Temp file */
	KTempFile temp("xsltexport-", "kwd");
	temp.setAutoDelete(true);
	TQFile* tempFile = temp.file();

	const TQ_LONG buflen = 4096;
	char buffer[ buflen ];
	TQ_LONG readBytes = _in->readBlock( buffer, buflen );

	while ( readBytes > 0 )
	{
		tempFile->writeBlock( buffer, readBytes );
		readBytes = _in->readBlock( buffer, buflen );
	}
	temp.close();

	kdDebug() << stylesheet << endl;
	XSLTProc* xsltproc = new XSLTProc(temp.name(), _fileOut, stylesheet);
	xsltproc->parse();

	delete xsltproc;

	kdDebug() << "XSLT FILTER --> END" << endl;
	reject(); // ###### accept() ? (Werner)
}

#include <xsltexportdia.moc>
