/* This file is part of the KDE project
   Copyright (C) 1999 David Faure <faure@kde.org>
   Copyright (C) 2004 Nicolas GOUTTE <goutte@kde.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef CSVEXPORTDIALOG_H
#define CSVEXPORTDIALOG_H

#include <kdialogbase.h>

class ExportDialogUI;
class TQValidator;

namespace KSpread
{
class Map;
}

class CSVExportDialog : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT
 public:
  CSVExportDialog(TQWidget * parent);
  ~CSVExportDialog();

  TQChar   getDelimiter() const;
  TQChar   getTextQuote() const;
  bool    exportSheet( TQString const & sheetName ) const;
  bool    printAlwaysSheetDelimiter() const;
  TQString getSheetDelimiter() const;  
  bool    exportSelectionOnly() const;

  void  fillSheet( KSpread::Map * map );
  TQString getEndOfLine(void) const;
  TQTextCodec* getCodec(void) const;

 private:
  void loadSettings();
  void saveSettings();
  ExportDialogUI * m_dialog;

  TQValidator* m_delimiterValidator;
  TQString m_delimiter;
  TQChar   m_textquote;

 private slots:
  void slotOk();
  void slotCancel();

  void returnPressed();
  void delimiterClicked( int id );
  void textChanged ( const TQString & );
  void textquoteSelected( const TQString & mark );
  void selectionOnlyChanged( bool );
};

#endif
