/* This file is part of the KDE project
   Copyright (C) 2001 Enno Bartels <ebartels@nwn.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef APPLIXSPREADIMPORT_H
#define APPLIXSPREADIMPORT_H

#include <tqstring.h>
#include <tqfile.h>
#include <tqobject.h>
#include <tqtextstream.h>
#include <tqptrlist.h>

#include <KoFilter.h>
#include <KoStore.h>

typedef struct
{
  int r;
  int g;
  int b;

  int c;
  int m;
  int y;
  int k;
} t_mycolor;

typedef struct
{
  TQStringList tabname;
  TQStringList rc;
} t_rc;


class APPLIXSPREADImport : public KoFilter {

    Q_OBJECT
  TQ_OBJECT

public:
    APPLIXSPREADImport ( TQObject *parent, const char* name, const TQStringList& );
    virtual ~APPLIXSPREADImport() {}

    virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );

protected:
    TQString nextLine           (TQTextStream &);
    TQChar   specCharfind       (TQChar , TQChar );
    void    writePen           (TQString &, int, int, TQString);
    TQString writeColor         (t_mycolor *);
    void    readTypefaceTable  (TQTextStream &, TQStringList &);
    void    readColormap       (TQTextStream &, TQPtrList<t_mycolor> &);
    void    readView           (TQTextStream &, TQString, t_rc &);
    void    filterSHFGBG       (TQString, int *, int *, int *);
    void    transPenFormat     (TQString, int *, int *);
    int     readHeader         (TQTextStream &);
    int     translateColumnNumber (TQString);

private:
    int m_stepsize;
    int m_instep;
    int m_progress;
};
#endif // APPLIXSPREADIMPORT_H
