/*
 *  Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *                2004 Sven Langkamp <longamp@reallygood.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _KIS_WDG_GRADIENT_SLIDER_H_
#define _KIS_WDG_GRADIENT_SLIDER_H_

#include <kpixmapio.h>
#include <tqwidget.h>

class KPopupMenu;
class KisAutogradientResource;
class KisGradientSegment;

class KisGradientSliderWidget : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    KisGradientSliderWidget(TQWidget *parent = 0, const char* name = 0, WFlags f = 0);

public:
    virtual void paintEvent ( TQPaintEvent * );
    void setGradientResource( KisAutogradientResource* agr);
    KisGradientSegment* selectedSegment() { return m_selectedSegment; };

signals:
    void sigSelectedSegment(KisGradientSegment*);
    void sigChangedSegment(KisGradientSegment*);

protected:
    virtual void mousePressEvent( TQMouseEvent * e );
    virtual void mouseReleaseEvent ( TQMouseEvent * e );
    virtual void mouseMoveEvent( TQMouseEvent * e );
    virtual void contextMenuEvent( TQContextMenuEvent * e );

private slots:
    void slotMenuAction(int id);

private:

    enum {
        NO_DRAG,
        LEFT_DRAG,
        RIGHT_DRAG,
        MIDDLE_DRAG
    };

    enum {
        SPLIT_SEGMENT,
        DUPLICATE_SEGMENT,
        MIRROR_SEGMENT,
        REMOVE_SEGMENT
    };

    KPixmapIO m_pixmapIO;
    KisAutogradientResource* m_autogradientResource;
    KisGradientSegment* m_currentSegment;
    KisGradientSegment* m_selectedSegment;
    KPopupMenu* m_segmentMenu;
    int m_drag;
};

#endif
