/*
 *  Copyright (c) 2002 Patrick Julien <freak@codepimps.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KIS_CONFIG_H_
#define KIS_CONFIG_H_

#include "kis_global.h"
#include "koffice_export.h"

class KRITACORE_EXPORT KisConfig {
public:
    KisConfig();
    ~KisConfig();

    bool fixDockerWidth() const;
    void setFixedDockerWidth(bool fix);
    
    bool undoEnabled() const;
    void setUndoEnabled(bool undo);
    
    TQ_INT32 defUndoLimit() const;
    void defUndoLimit(TQ_INT32 limit);

    TQ_INT32 defImgWidth() const;
    void defImgWidth(TQ_INT32 width);

    TQ_INT32 defImgHeight() const;
    void defImgHeight(TQ_INT32 height);

    double defImgResolution() const;
    void defImgResolution(double res);

    enumCursorStyle cursorStyle() const;
    enumCursorStyle getDefaultCursorStyle() const;
    void setCursorStyle(enumCursorStyle style);

    TQString monitorProfile() const;
    void setMonitorProfile(TQString monitorProfile);

    TQString workingColorSpace() const;
    void setWorkingColorSpace(TQString workingColorSpace);

    TQString importProfile() const;
    void setImportProfile(TQString importProfile);

    TQString printerColorSpace() const;
    void setPrinterColorSpace(TQString printerColorSpace);

    TQString printerProfile() const;
    void setPrinterProfile(TQString printerProfile);

    bool useBlackPointCompensation() const;
    void setUseBlackPointCompensation(bool useBlackPointCompensation);

    bool showRulers() const;
    void setShowRulers(bool rulers);

    TQ_INT32 pasteBehaviour() const;
    void setPasteBehaviour(TQ_INT32 behaviour);

    TQ_INT32 renderIntent() const;
    void setRenderIntent(TQ_INT32 renderIntent);

    bool useOpenGL() const;
    void setUseOpenGL(bool useOpenGL);

    bool useOpenGLShaders() const;
    void setUseOpenGLShaders(bool useOpenGLShaders);

    TQ_INT32 maxNumberOfThreads();
    void setMaxNumberOfThreads(TQ_INT32 numberOfThreads);

    /// Maximum tiles in memory (this is a guideline, not absolute)
    TQ_INT32 maxTilesInMem() const;
    void setMaxTilesInMem(TQ_INT32 tiles);

    /// Number of tiles that will be swapped at once. The higher, the more swapped, but more
    /// chance that it will become slow
    TQ_INT32 swappiness() const;
    void setSwappiness(TQ_INT32 swappiness);

    TQ_INT32 getPressureCorrection();
    void setPressureCorrection( TQ_INT32 correction);
    TQ_INT32 getDefaultPressureCorrection();

    bool tabletDeviceEnabled(const TQString& tabletDeviceName) const;
    void setTabletDeviceEnabled(const TQString& tabletDeviceName, bool enabled);

    TQ_INT32 tabletDeviceAxis(const TQString& tabletDeviceName, const TQString& axisName, TQ_INT32 defaultAxis) const;
    void setTabletDeviceAxis(const TQString& tabletDeviceName, const TQString& axisName, TQ_INT32 axis) const;

    TQ_INT32 dockability();
    TQ_INT32 getDefaultDockability();
    void setDockability( TQ_INT32 dockability);

    float dockerFontSize();
    float getDefaultDockerFontSize();
    void setDockerFontSize(float);

    
    TQ_UINT32 getGridMainStyle();
    void setGridMainStyle(TQ_UINT32 v);
    TQ_UINT32 getGridSubdivisionStyle();
    void setGridSubdivisionStyle(TQ_UINT32 v);
    TQColor getGridMainColor();
    void setGridMainColor(TQColor v);
    TQColor getGridSubdivisionColor();
    void setGridSubdivisionColor(TQColor v);
    TQ_UINT32 getGridHSpacing();
    void setGridHSpacing(TQ_UINT32 v);
    TQ_UINT32 getGridVSpacing();
    void setGridVSpacing(TQ_UINT32 v);
    TQ_UINT32 getGridSubdivisions();
    void setGridSubdivisions(TQ_UINT32 v);
    TQ_UINT32 getGridOffsetX();
    void setGridOffsetX(TQ_UINT32 v);
    TQ_UINT32 getGridOffsetY();
    void setGridOffsetY(TQ_UINT32 v);

    
private:
    KisConfig(const KisConfig&);
    KisConfig& operator=(const KisConfig&);

private:
    mutable KConfig *m_cfg;
};

#endif // KIS_CONFIG_H_
