/*
 *  Copyright (c) 2006 Boudewijn Rempt
 *
 *  this program is free software; you can redistribute it and/or modify
 *  it under the terms of the gnu general public license as published by
 *  the free software foundation; either version 2 of the license, or
 *  (at your option) any later version.
 *
 *  this program is distributed in the hope that it will be useful,
 *  but without any warranty; without even the implied warranty of
 *  merchantability or fitness for a particular purpose.  see the
 *  gnu general public license for more details.
 *
 *  you should have received a copy of the gnu general public license
 *  along with this program; if not, write to the free software
 *  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
 */
#ifndef KIS_ADJUSTMENT_LAYER_H_
#define KIS_ADJUSTMENT_LAYER_H_

#include <tqobject.h>
#include "kis_types.h"
#include "kis_layer_visitor.h"
#include "kis_composite_op.h"
#include <koffice_export.h>

class KNamedCommand;
class TQPainter;
class KisUndoAdapter;
class KisGroupLayer;
class KisFilterConfiguration;

/**
 * Class that contains a KisFilter and optionally a KisSelection. The combination
 * is used by to influence the rendering of the layers under this layer in the
 * layerstack
 **/
class KRITACORE_EXPORT KisAdjustmentLayer : public KisLayer, public KisLayerSupportsIndirectPainting
{
    Q_OBJECT
  TQ_OBJECT

public:
    /**
     * Create a new adjustment layer with the given configuration and selection.
     * Note that the selection will be _copied_. 
     */
    KisAdjustmentLayer(KisImageSP img, const TQString &name, KisFilterConfiguration * kfc, KisSelectionSP selection);
    KisAdjustmentLayer(const KisAdjustmentLayer& rhs);
    virtual ~KisAdjustmentLayer();

    /// Return a copy of this layer
    virtual KisLayerSP clone() const;

public:
    
    KisFilterConfiguration * filter();
    void setFilter(KisFilterConfiguration * filterConfig);

    KisSelectionSP selection();
    
    /// Set the selction of this adjustment layer to a copy of selection.
    void setSelection(KisSelectionSP selection);

    /// Clears the selection (doesn't call any of the update or dirty methods)
    void clearSelection();

    virtual void paintSelection(TQImage &img, TQ_INT32 x, TQ_INT32 y, TQ_INT32 w, TQ_INT32 h);
    virtual void paintSelection(TQImage &img, const TQRect& scaledImageRect, const TQSize& scaledImageSize, const TQSize& imageSize);
public:
    
    virtual TQ_INT32 x() const;
    virtual void setX(TQ_INT32);

    virtual TQ_INT32 y() const;
    virtual void setY(TQ_INT32);

    /// Returns an approximation of where the bounds on actual data are in this layer
    virtual TQRect extent() const;
    
    /// Returns the exact bounds of where the actual data resides in this layer
    virtual TQRect exactBounds() const;

    virtual bool accept(KisLayerVisitor &);

    virtual void resetCache();
    virtual KisPaintDeviceSP cachedPaintDevice() { return m_cachedPaintDev; }

    bool showSelection() const { return m_showSelection; }
    void setSelection(bool b) { m_showSelection = b; }

    virtual TQImage createThumbnail(TQ_INT32 w, TQ_INT32 h);

    // KisLayerSupportsIndirectPainting
    virtual KisLayer* layer() { return this; }
private:
    bool m_showSelection;
    KisFilterConfiguration * m_filterConfig;
    KisSelectionSP m_selection;
    KisPaintDeviceSP m_cachedPaintDev;
private slots:
    void slotSelectionChanged(KisImageSP image);
};

#endif // KIS_ADJUSTMENT_LAYER_H_

