/***************************************************************************
                          knutmessagemanager.cpp  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutmessagemanager.h"
#include <tqstring.h>

KNutMessageManager::KNutMessageManager(  TQObject *parent, const char *name) : TQObject (parent, name) {
//qDebug("KNutMessageManager::KNutMessageManager");


  m_myMess =0;
  m_myMessLevel = knc::infoLevel;
  m_xPos=0;
  m_yPos=0;
  }



KNutMessageManager::~KNutMessageManager(){

  deleteMessage ();
  }


void KNutMessageManager::deleteMessage (void) {

  if (m_myMess) {
    disconnect (m_myMess,TQT_SIGNAL(finished()),this,TQT_SLOT(slotFinishedMessage()));
    disconnect (m_myMess,TQT_SIGNAL(endMessage()),this,TQT_SLOT(slotEndMessage()));
    disconnect (m_myMess,TQT_SIGNAL(messageMoved(int,int)),this,TQT_SLOT(slotMessageMoved(int,int)));
    m_myMess->hide();
    delete m_myMess;
    m_myMess = 0;
    }
  }

void KNutMessageManager::addMessage (TQString text, knc::LevelOfMessage messageLevel, bool useInfoIcon, bool useShortTimeOfValidity) {
long int timeOfMessageValidity;

  if (useShortTimeOfValidity) timeOfMessageValidity = ShortTimeOfValidity;
  else timeOfMessageValidity = TimeOfValidity;
//qDebug("KNutMessageManager::addMessage");

  deleteMessage();
  if (useInfoIcon) m_myMess = new KNutMessage(text,KNutMessage::infoMess,timeOfMessageValidity);
  else {
    switch (messageLevel) {
      case knc::infoLevel:
        m_myMess = new KNutMessage(text,KNutMessage::infoMess,timeOfMessageValidity);
        break;
      case knc::lowWarningLevel:
        m_myMess = new KNutMessage(text,KNutMessage::warningMess,timeOfMessageValidity);
        break;
      case knc::warningLevel:
        m_myMess = new KNutMessage(text,KNutMessage::warningMess,timeOfMessageValidity);
        break;
      case knc::errorLevel:
        m_myMess = new KNutMessage(text,KNutMessage::criticalMess,timeOfMessageValidity);
        break;
      case knc::criticalLevel:
        m_myMess = new KNutMessage(text,KNutMessage::criticalMess,TimeOfValidity); //validity time of critical message has to be standard time of Validity, this time doesn't be short time
       break;
      }
    }
  m_myMessLevel=messageLevel;
  if ((m_xPos != 0) && (m_yPos !=0)) {
    m_myMess->move (m_xPos, m_yPos);
    }

  m_myMess->show();
  connect (m_myMess,TQT_SIGNAL(finished()),this,TQT_SLOT(slotFinishedMessage()));
  connect (m_myMess,TQT_SIGNAL(endMessage()),this,TQT_SLOT(slotEndMessage()));
  connect (m_myMess,TQT_SIGNAL(messageMoved(int,int)),this,TQT_SLOT(slotMessageMoved(int,int)));
  }


void KNutMessageManager::slotFinishedMessage (void) {

  if (m_myMess) {
    disconnect (m_myMess,TQT_SIGNAL(finished()),this,TQT_SLOT(slotFinishedMessage()));
    disconnect (m_myMess,TQT_SIGNAL(endMessage()),this,TQT_SLOT(slotEndMessage()));
    disconnect (m_myMess,TQT_SIGNAL(messageMoved(int,int)),this,TQT_SLOT(slotMessageMoved(int,int)));
    m_myMess->hide();
    m_myMess->deleteLater();
    m_myMess=0;
    }
  }

void KNutMessageManager::slotEndMessage (void) {
 //kdyz dojde ke stisku tlacitka OK, nebo vyprsi doba platnosti (timeValidity)

  deleteMessage();
  }


void KNutMessageManager::slotMessageMoved (int x,int y) {

//qDebug("KNutMessageManager::slotMessageMoved");
  m_xPos=x;
  m_yPos=y;
}





#include "knutmessagemanager.moc"
