/***************************************************************************
                          knutinstcomms.cpp  -  description
                             -------------------
    begin                : ct rj 24 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutinstcomms.h"
#include "knutprintupsvar.h"
#include "knutvardata.h"

#include <kcombobox.h>
#include <kmessagebox.h>


#include <tqlayout.h> 
#include <tqframe.h>
#include <tqlabel.h>
#include <tqstring.h>


KNutInstComms::KNutInstComms(TQString* userName, TQString* userPassword, const TQString uName, const TQString password, KNutNet* const upsNet, TQWidget* parent,  const char* name, const bool modal)
: KDialogBase(Plain, i18n("Instant commands"),Ok|Cancel,Ok, parent, name, modal, true), m_upsNet(upsNet),m_oldUserName(userName), m_oldUserPassword(userPassword)  {
  upsICommDef upsIComm;


   if (m_upsNet->getState() != KNutNet::Connected) { // no connection - no instant commnads
     KNutVarData::showError (KNutNet::NotConnection);
     m_upsConnectOk=false;
     }
  else {
    m_upsConnectOk=true;
    TQFrame *page = plainPage();
    TQVBoxLayout *topLayout = new TQVBoxLayout( page, 0, spacingHint() );
    TQLabel *label1 = new TQLabel (i18n("RUN INSTANT COMMAND"),page,"label1");
    label1->setAlignment(TQt::AlignHCenter);
    topLayout->addWidget(label1);

    TQLabel *label2 = new TQLabel (i18n("Command:"),page,"label2");
    m_instCommBox = new KComboBox(page,"instcommbox");

    TQGridLayout *passLayout = new TQGridLayout (3,2,5,"passLayout");
    TQLabel *labelName = new TQLabel (i18n("User name:"),page,"labelName");
    TQLabel *labelPassword = new TQLabel (i18n("Password:"),page,"labelPassword");
    m_lineEditName = new KLineEdit( page, "LineEditName" );
    m_lineEditPassword = new KLineEdit( page, "LineEditName" );
    if (((*m_oldUserName) == "") && ((*m_oldUserPassword) == "")) {
      m_lineEditName->setText(uName);
      m_lineEditPassword->setText(password);
      }
    else {
      m_lineEditName->setText(*m_oldUserName);
      m_lineEditPassword->setText(*m_oldUserPassword);
      m_lineEditName->setDisabled(true);
      m_lineEditPassword->setDisabled(true);
      }

 //   if (!((*oldUserName) == "") || !((*oldUserPassword) == "")) {
 //   if (!((*oldUserName) == "") && ((*oldUserPassword) == "")) {
 //     lineEditName->setDisabled(true);
 //     lineEditPassword->setDisabled(true);
 //     }

    m_lineEditPassword->setEchoMode(TQLineEdit::Password);

    topLayout->addLayout(passLayout);

    passLayout->addWidget(label2,0,0);
    passLayout->addWidget(m_instCommBox,0,1);

    passLayout->addWidget(labelName,1,0);
    passLayout->addWidget(labelPassword,2,0);
    passLayout->addWidget(m_lineEditName,1,1);
    passLayout->addWidget(m_lineEditPassword,2,1);

    topLayout->addStretch(10);

   //loads ComboBox
    int n = m_upsNet->readNumberComms()+1;
    for (int i =1; i < n ; i++) { // for se testuje na zacatku pokud je n < 1 neprovede se ani jednou
      if (!m_upsNet->readIComm(i, upsIComm))
        m_instCommBox->insertItem(upsIComm.upsCommName);
      }
    }
  }

KNutInstComms::~KNutInstComms(){
}


void KNutInstComms::slotOk() {
  int error =0;


  if (((*m_oldUserName) == "") && ((*m_oldUserPassword) == "")) {
    // prvni propojeni nastavime jmeno a heslo
    //for the first connection we have to set name and password
    if (!( error = m_upsNet->instantCommand(m_instCommBox->currentText(),m_lineEditName->text(),m_lineEditPassword->text(),false))) {
      (*m_oldUserName) = m_lineEditName->text();
      (*m_oldUserPassword) = m_lineEditPassword->text();
      accept();
      }
    }
  else {
    // for other connection name and password are not setted
    if (((*m_oldUserName) == m_lineEditName->text()) && ((*m_oldUserPassword) == m_lineEditPassword->text())) {
      // jen posleme prikaz // sends command only
      if (!( error = m_upsNet->instantCommand(m_instCommBox->currentText(),m_lineEditName->text(),m_lineEditPassword->text(),true))) accept();
      }
// az v pristi verzi
//    else
//      {
//      // odpojime a pripojime
//      // nastavime jmeno a heslo
//      if (!( error = myUpsNet->instantCommand(instCommBox->currentText(),lineEditName->text(),lineEditPassword->text(),false))) {
//        (*oldUserName) = lineEditName->text();
//        (*oldUserPassword) = lineEditPassword->text();
//        accept();
//        }
//      }
    }
  if (error) KNutVarData::showError (error);
  }

//bool KNutInstComms::upsOk (void) { return m_upsConnectOk; }


