/***************************************************************************
                          knowitpref.h  -  description
                             -------------------
    begin                : czw lis 28 2002
    copyright            : (C) 2002-2004 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNOWITPREF_H
#define KNOWITPREF_H

#include <tqstring.h>
#include <kdialogbase.h>

class TQCheckBox;
class TQSpinBox;
class TQToolButton;
class KLineEdit;
class KColorButton;
class KDualColorButton;
class KConfig;
class KComboBox;

class KnowitOptions
{
public:
   /* General */
   bool docked;
   bool reopen;
   int autosave;
   bool unconditionalSave;
   bool multipleInstances;
   bool backup;
   /* GUI */
   bool horizontalSplit;
   int linkFormat;
   TQString defaultName;
   bool alternateTree;
   TQString alternateColor;
   bool autoCollapse;
   /* Links */
   bool firstLink;
   /* Editor */
   bool wordwrap;
   bool enterBreakLine;
   bool tabfocus;
   bool customColors;
   TQString backEditColor;
   TQString foreEditColor;
   bool customFont;
   TQString fontFamily;
   int fontSize;
   /* Date format */
   TQString insertDateFormat, insertDateColor;
   bool insertDateBold, insertDateItalic, insertDateUnderline;
   void save(KConfig* config) const;
   void read(KConfig* config);
   /* Export */
   int exportFlags;
};


class KnowitPreferences : public KDialogBase
{
Q_OBJECT
  TQ_OBJECT
private:
   TQCheckBox *docked, *reopen, *horizontalSplit,  *multipleInstances, *backup;
   TQCheckBox *unconditionalSave;
   TQCheckBox *wordwrap, *tabfocus, *customColors;
   KDualColorButton* editColors;
   TQCheckBox *enterBreakLine;   
   KLineEdit *defaultName;
   TQCheckBox *alternateTree;
   KColorButton *alternateColor;
   TQCheckBox* autoCollapse;
   TQCheckBox* customFont;
   KComboBox *fontFamily, *fontSize;
   KComboBox *linkFormat;
   KLineEdit *insertDateFormatEdit;
   KColorButton *insertDateColorButton;
   TQLabel *insertDatePreview;
   TQSpinBox* autosave;
   TQToolButton *insertDateItalicButton, *insertDateBoldButton, *insertDateUnderlineButton;
   bool firstLink;
   int exportFlags;   
public:
    KnowitPreferences();
    void setOptions(const KnowitOptions& Options);
    KnowitOptions getOptions() const;
    public slots:
    void slotUpdateDatePreview();
};

#endif

