/***************************************************************************
                          wiz_setup.h  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WIZ_SETUP_H
#define WIZ_SETUP_H

#include <kwizard.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlabel.h>
#include "resource.h"
#include "definitions.h"
#include "knightstextview.h"

/**
  *@author Troy Corbin Jr.
  */

class wiz_setup : public KWizard
{
		Q_OBJECT
  TQ_OBJECT
		public:
									wiz_setup( TQWidget *parent=0, const char *name=0, resource *Rsrc=0 );
									~wiz_setup();
		protected slots:
			void				slot_Work( const TQString& pageTitle );
			void				slot_License( int );
		protected:
			void			  initPage1( void );
			void			  initPage2( void );
			void			  initPage3( void );
			void			  initPage4( void );
			void			  initPage5( void );
			void			  initPage6( void );
			void				findEngines( void );
			void				setupServers( void );
			void				setupPGN( void );
		private:
			resource		*myResource;
			int					steps;

			TQFrame				*Page1;
				TQGridLayout		*P1B1;
					TQLabel			*SideImage1;
					TQLabel			*WelcomeMessage;
			TQFrame				*Page2;
				TQGridLayout		*P2B1;
					TQLabel				*SideImage2;
					TQLabel				*pgnExplain;
					TQButtonGroup	*pgnButtons;
						TQRadioButton	*pgnYes;
						TQRadioButton	*pgnNo;
			TQFrame				*Page3;
				TQGridLayout		*P3B1;
					TQLabel			*SideImage3;
					TQLabel			*engineExplain;
					TQButtonGroup	*engineButtons;
						TQRadioButton	*engineYes;
						TQRadioButton	*engineNo;
			TQFrame				*Page4;
				TQGridLayout		*P4B1;
					TQLabel			*SideImage4;
					TQLabel			*serverExplain;
					TQButtonGroup	*serverButtons;
						TQRadioButton	*serverYes;
						TQRadioButton	*serverNo;
			TQFrame				*Page5;
				TQGridLayout		*P5B1;
					TQLabel			*SideImage5;
					TQLabel			*FinishExplain;
			TQVBox					*Page6;
				KnightsTextView	*licenseView;
				TQButtonGroup	*licenseButtons;
					TQRadioButton	*licenseYes;
					TQRadioButton	*licenseNo;
};

#endif
