/***************************************************************************
                          wiz_setup.cpp  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobalsettings.h>
#include <kprocess.h>
#include <kstddirs.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqregexp.h>
#include "wiz_setup.moc"

wiz_setup::wiz_setup(TQWidget *parent, const char *name, resource *Rsrc ) : KWizard(parent,name,TRUE)
{                                                                                                            	
	myResource = Rsrc;
	steps = 0;
	setMaximumSize( 800, 600 );

	/*
			Call Order Of Pages:

				Page 1 - Introduction
				Page 6 - Accept License
				Page 3 - Setup Engines
				Page 4 - Setup Servers
				Page 5 - Finished
	*/
	initPage1();
//	initPage6();
	if( myResource->Config_Version < 1 )
	{
//		initPage2();
		initPage3();
		initPage4();
	}
	initPage5();
	setCaption( i18n( "Knights Setup Wizard" ) );

	connect( this, TQT_SIGNAL( selected(const TQString&) ), this, TQT_SLOT( slot_Work(const TQString&) ) );
}
wiz_setup::~wiz_setup()
{
}
///////////////////////////////////////
//
//	wiz_setup::initPage1
//
///////////////////////////////////////
void wiz_setup::initPage1( void )
{
	Page1 = new TQFrame( this );
	P1B1 = new TQGridLayout( Page1, 1, 4, 8 );

	SideImage1 = new TQLabel( Page1 );
	SideImage1->setPixmap( locate("data", "knights/wizard.png" ) );
	P1B1->addWidget( SideImage1, 1, 1 );

	WelcomeMessage = new TQLabel( Page1 );
	WelcomeMessage->setAlignment( TQt::AlignLeft | TQt::AlignTop | TQt::WordBreak );
	WelcomeMessage->setText( i18n( "Thank you for installing Knights, the graphical chess interface for KDE. To help you get started quickly, there are a few things Knights will need to setup. You should click 'Next' to see what they are." ) );
	P1B1->addWidget( WelcomeMessage, 1, 3 );

	addPage( Page1, i18n("Welcome to Knights v%1!").arg(_VERSION_) );
	setNextEnabled( Page1, TRUE );
	setHelpEnabled( Page1, FALSE );
}
///////////////////////////////////////
//
//	wiz_setup::initPage2
//
///////////////////////////////////////
void wiz_setup::initPage2( void )
{
	Page2 = new TQFrame( this );
	P2B1 = new TQGridLayout( Page2, 2, 4, 8 );

	SideImage2 = new TQLabel( Page2 );
	SideImage2->setPixmap( locate("data", "knights/wizard.png" ) );
	P2B1->addMultiCellWidget( SideImage2, 1, 2, 1, 1 );

	pgnExplain = new TQLabel( Page2 );
	pgnExplain->setAlignment( TQt::AlignLeft | TQt::AlignTop | TQt::WordBreak );
	pgnExplain->setText( i18n( "When Knights saves a match to disk, it uses Portable Game Notation (PGN) to store the match. Several other computer chess games use PGN too. If you like, Knights can be the default PGN viewer on this system." ) );
	P2B1->addWidget( pgnExplain, 1, 3 );

	pgnButtons = new TQButtonGroup( 2, Qt::Vertical, i18n( "Let Knights handle PGN files?" ), Page2 );
		pgnYes = new TQRadioButton( i18n( "Yes" ), pgnButtons );
		pgnNo = new TQRadioButton( i18n( "No" ), pgnButtons );
	pgnButtons->setButton( 0 );
	P2B1->addWidget( pgnButtons, 2, 3 );

	addPage( Page2, i18n("Let Knights handle your .pgn files?") );
	setHelpEnabled( Page2, FALSE );
}
///////////////////////////////////////
//
//	wiz_setup::initPage3
//
///////////////////////////////////////
void wiz_setup::initPage3( void )
{
	Page3 = new TQFrame( this );
	P3B1 = new TQGridLayout( Page3, 2, 4, 8 );

	SideImage3 = new TQLabel( Page3 );
	SideImage3->setPixmap( locate("data", "knights/wizard.png" ) );
	P3B1->addMultiCellWidget( SideImage3, 1, 2, 1, 1 );

	engineExplain = new TQLabel( Page3 );
	engineExplain->setAlignment( TQt::AlignLeft | TQt::AlignTop | TQt::WordBreak );
	engineExplain->setText( i18n( "Knights can not play a chess match against you without help. Known as Chess Engines, these helpers can be found on the Internet and are often included with your distribution. Knights can look for Chess Engines that you may already have. If found, Knights will configure itself to use them." ) );
	P3B1->addWidget( engineExplain, 1, 3 );

	engineButtons = new TQButtonGroup( 2, Qt::Vertical, i18n( "Let Knights search for chess engines?" ), Page3 );
		engineYes = new TQRadioButton( i18n( "Yes" ), engineButtons );
		engineNo = new TQRadioButton( i18n( "No" ), engineButtons );
	engineButtons->setButton( 0 );
	P3B1->addWidget( engineButtons, 2, 3 );

	addPage( Page3, i18n("Let Knights search for chess engines?") );
	setHelpEnabled( Page3, FALSE );
}
///////////////////////////////////////
//
//	wiz_setup::initPage4
//
///////////////////////////////////////
void wiz_setup::initPage4( void )
{
	Page4 = new TQFrame( this );
	P4B1 = new TQGridLayout( Page4, 2, 4, 8 );

	SideImage4 = new TQLabel( Page4 );
	SideImage4->setPixmap( locate("data", "knights/wizard.png" ) );
	P4B1->addMultiCellWidget( SideImage4, 1, 2, 1, 1 );

	serverExplain = new TQLabel( Page4 );
	serverExplain->setAlignment( TQt::AlignLeft | TQt::AlignTop | TQt::WordBreak );
	serverExplain->setText( i18n( "In order for you to play chess online, Knights will have to connect to a chess server. Knights has a list of several of these servers. If you like, this list can be used to automatically configure Knights." ) );
	P4B1->addWidget( serverExplain, 1, 3 );

	serverButtons = new TQButtonGroup( 2, Qt::Vertical, i18n( "Let Knights configure chess servers?" ), Page4 );
		serverYes = new TQRadioButton( i18n( "Yes" ), serverButtons );
		serverNo = new TQRadioButton( i18n( "No" ), serverButtons );
	serverButtons->setButton( 0 );
	P4B1->addWidget( serverButtons, 2, 3 );

	addPage( Page4, i18n("Let Knights configure chess servers?") );
	setHelpEnabled( Page4, FALSE );
}
///////////////////////////////////////
//
//	wiz_setup::initPage5
//
///////////////////////////////////////
void wiz_setup::initPage5( void )
{
	Page5 = new TQFrame( this );
	P5B1 = new TQGridLayout( Page5, 2, 4, 8 );

	SideImage5 = new TQLabel( Page5 );
	SideImage5->setPixmap( locate("data", "knights/wizard.png" ) );
	P5B1->addMultiCellWidget( SideImage5, 1, 2, 1, 1 );

	FinishExplain = new TQLabel( Page5 );
	FinishExplain->setAlignment( TQt::AlignLeft | TQt::AlignTop | TQt::WordBreak );
	FinishExplain->setText( i18n( "Knights has now configured itself according to your choices. We strongly recommend that you read the documentation to make full use of all that Knights has to offer. You can access it by pressing F1." ) );
	P5B1->addWidget( FinishExplain, 1, 3 );

	addPage( Page5, i18n("Setup Complete") );
	setFinish( Page5, TRUE );
	setHelpEnabled( Page5, FALSE );
}
///////////////////////////////////////
//
//	wiz_setup::initPage6
//
///////////////////////////////////////
void wiz_setup::initPage6( void )
{
	TQString f( locate("data", "LICENSES/GPL_V2") );
	TQString licenseText("<K_STD>");
	Page6 = new TQVBox( this );

	/* Setup License View */
	licenseView = new KnightsTextView( Page6, myResource );
	if (!f.isEmpty())
	{
		TQFile file(f);
		if (file.open(IO_ReadOnly))
		{
			TQTextStream str(&file);
			licenseText += str.read();
		}
	}
	licenseText.append( "</K_STD>" );
	licenseView->setText( licenseText );

	licenseButtons = new TQButtonGroup( 2, Qt::Horizontal, i18n( "Do you accept the terms of our license?" ), Page6 );
		licenseYes = new TQRadioButton( i18n( "Yes" ), licenseButtons );
		licenseNo = new TQRadioButton( i18n( "No" ), licenseButtons );
	licenseButtons->setButton( 1 );

	addPage( Page6, i18n("Please read and accept our license:") );
	setHelpEnabled( Page6, FALSE );
	connect( licenseButtons, TQT_SIGNAL( clicked(int) ), this, TQT_SLOT( slot_License(int) ) );
}
///////////////////////////////////////
//
//	wiz_setup::slot_Work
//
///////////////////////////////////////
void wiz_setup::slot_Work( const TQString& pageTitle )
{
	/* Don't let 'em past the license */
	if( pageTitle == title( Page6 ) )
	{
		setNextEnabled( Page6, FALSE );
	}

	/* Don't proceed unless we're ready to work */
	if( pageTitle != title( Page5 ) ) return;
	setBackEnabled( Page5, FALSE );
	if( myResource->Config_Version < 1 )
	{
//		if( pgnButtons->selected() == pgnYes )
//			setupPGN();
		if( engineButtons->selected() == engineYes )
			findEngines();
		if( serverButtons->selected() == serverYes )
			setupServers();
	}
	myResource->ConfigWrite();
	setFinishEnabled( Page5, TRUE );
}
///////////////////////////////////////
//
//	wiz_setup::setupPGN
//
///////////////////////////////////////
void wiz_setup::setupPGN( void )
{
}
///////////////////////////////////////
//
//	wiz_setup::setupServers
//
///////////////////////////////////////
void wiz_setup::setupServers( void )
{
	serverResource *newServer;
	TQStringList names, urls, ports;
	unsigned int loop;

	names << i18n("Free Internet Chess Server") << i18n("Internet Chess Club") << i18n("Global Chess Server") << i18n("Chess.Net");
	names << i18n("Chess-Square.Com") << i18n("Australian FICS") << i18n("Brazilian FICS") << i18n("Chilean FICS");
	names << i18n("Croatian FICS") << i18n("Dutch FICS") << i18n("French FICS") << i18n("German FICS") << i18n("Swedish FICS");
	urls << "freechess.org" << "chessclub.com" << "global.chessparlor.com" << "chess.net";
	urls << "chess-square.com" << "zics.org" << "jogo.cex.org.br" << "ajedrez.cec.uchile.cl";
	urls << "fly.cc.fer.hr" << "freechess.nl" << "jeu.echecs.com" << "chess.unix-ag.uni-kl.de" << "chess.mds.mdh.se";
	ports << "5000" << "5000" << "6000" << "5000" << "5000" << "5000" << "5000" << "5000";
	ports << "7890" << "5000" << "5000" << "5000" << "5000";

	for( loop = 0; loop < names.count(); loop++ )
	{
			kdDebug() << "adding " << names[loop] << endl;
			newServer = new serverResource;
			newServer->Name = names[loop];
			newServer->URL = urls[loop];
			newServer->Port = ports[loop].toInt();
			newServer->LogFile = TQString();
			newServer->UserName = TQString();
			newServer->Password = TQString();
			newServer->StorePass = FALSE;
			if( !loop ) newServer->CurrentRef = TRUE;
			else  newServer->CurrentRef = FALSE;
			myResource->servers.append( *newServer );
			delete newServer;
	}
}
///////////////////////////////////////
//
//	wiz_setup::findEngines
//
///////////////////////////////////////
void wiz_setup::findEngines( void )
{
	engineResource *newEngine;
	TQStringList names, filenames;
	KProcess *Shell;
	bool foundOne( FALSE );
	unsigned int loop;

	names << "GNUChess" << "Crafty" << "Sjeng" << "KnightCap" << "BabyChess" << "Phalanx-XXII";
	names << "Bowron Abernethy Chess Engine" << "Cilian" << "Faile" << "OliThink" << "Pepito";
	names << "Yace";
	filenames << "gnuchessx" << "crafty" << "sjeng" << "KnightCap" << "babychess-xboard-engine";
	filenames << "phalanx" << "BACE" << "linuxCilian.exe" << "faile" << "olithink" << "pepito";
	filenames << "yace";

	for( loop = 0; loop < filenames.count(); loop++ )
	{
		Shell = new KProcess();
		(*Shell) << filenames[loop];
		if( Shell->start() )
		{
			kdWarning() << "Adding " << names[loop] << " to knightsrc" << endl;
			newEngine = new engineResource;
			newEngine->Name = names[loop];
			newEngine->Filename = filenames[loop];
			newEngine->Arguments = TQString();
			newEngine->LogFile = TQString();
			newEngine->Protocol = XBoard;
			newEngine->Wins = 0;
			newEngine->Losses = 0;
			newEngine->Draws = 0;
			if( foundOne )
				newEngine->CurrentRef = 0;
			else
				newEngine->CurrentRef = ENGINE_WHITE | ENGINE_BLACK | ENGINE_WHITE_BK | ENGINE_BLACK_BK;
			myResource->engines.append( *newEngine );
			delete newEngine;
			foundOne = TRUE;
		}
		Shell->kill();
		delete Shell;
	}
}
///////////////////////////////////////
//
//	wiz_setup::slot_License
//
///////////////////////////////////////
void wiz_setup::slot_License( int index )
{
	if( index == 0 )
	{
		setNextEnabled( Page6, TRUE );
		myResource->Accepted_License = TRUE;
	}
	else
	{
		setNextEnabled( Page6, FALSE );
		myResource->Accepted_License = FALSE;
	}
}
