/***************************************************************************
                          thinbuttons.h  -  description
                             -------------------
    begin                : Tue Nov 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THINBUTTONS_H
#define THINBUTTONS_H

#include <kpopupmenu.h>
#include <tqframe.h>
#include <tqbutton.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */
struct Buttons
{
	TQButton		*button;
	int				ID;
};

class thinbuttons : public TQFrame
{
	Q_OBJECT
  TQ_OBJECT
	public:
								thinbuttons(TQWidget *parent=0, const char *name=0, resource *Rsrc=0);
								~thinbuttons();
		void				mousePressEvent( TQMouseEvent *event );
		void				setButton( int id );
		TQButton*		find( int id );
		TQButton*		create( int id );
		void				remove( TQButton* button );
		void				remove( const int &id );
		void				resize( const int Width );
		int					id( TQButton * );

	signals:
		void				leftClick( int id );
		void				rightClick( int id );
		void				menuItemSelected( int id, int item );

	protected slots:
		void				buttonClicked(void);
		void				menuClicked( int item );

	protected:
		void				childEvent( TQChildEvent * );

	private:
		resource										*Resource;
		KPopupMenu									*matchMenu;
		TQList<Buttons>							buttons;
		int													buttWidth;
		int													rightClickID;
};

#endif
