/***************************************************************************
                          tabbox.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabbox.moc"
#include "tabpage.h"
#include "resource.h"
#include "accel.h"
#include <klocale.h>
#include <tqstyle.h>
#include <tqtabwidget.h>

TabBox::TabBox( resource *rsrc ) : TQVBox(0,"TabBox",TQt::WDestructiveClose)
{
	myResource = rsrc;
	setMargin( TQApplication::style().defaultFrameWidth() );

	myTabs = new TQTabWidget( this, "myTabs" );
	myTabs->setTabShape( TQTabWidget::Rounded );
	myTabs->setTabPosition( TQTabWidget::Top );

	myAccel = new Accel( this, myResource->myAccel );

	connect( myTabs, TQT_SIGNAL( currentChanged( TQWidget* ) ), this, TQT_SLOT( changeMyCaption( TQWidget* ) ) );
	connect( this, TQT_SIGNAL( focus( const TQChar& ) ), myResource->myAccel, TQT_SIGNAL( focus( const TQChar& ) ) );
}
TabBox::~TabBox()
{
	while( myTabs->count() )
	{
		removeTab( myTabs->page(0), TRUE );
	}
	delete myAccel;
}
///////////////////////////////////////
//
//	TabBox::keyPressEvent
//
///////////////////////////////////////
void TabBox::keyPressEvent( TQKeyEvent *e )
{
	TQChar input;

	if( ( e->state() | TQt::ShiftButton ) == TQt::ShiftButton )
	{
		input = e->text().at(0);
		if( input.isLetterOrNumber() )
		{
			emit focus( input );
			e->accept();
			return;
		}
	}
	e->ignore();
}
///////////////////////////////////////
//
//	TabBox::addTab
//
///////////////////////////////////////
void TabBox::addTab( TQWidget *child, const TQString &caption )
{
	if( TQString( child->className() ) == "TabPage" )
	{
		myTabs->addTab( child, caption );
		myTabs->showPage( child );
		changeMyCaption( child );
		connect( child, TQT_SIGNAL( newParent( TabBox* ) ), this, TQT_SIGNAL( newTabBox( TabBox* ) ) );
		connect( child, TQT_SIGNAL( requestDestruction() ), this, TQT_SLOT( destroyChild() ) );
	}
	else
	{
		TabPage *newPage = new TabPage( (TQWidget*)this, child, myResource );
		newPage->setCaption( caption );

		myTabs->addTab( newPage, caption );
		myTabs->showPage( newPage );
		changeMyCaption( newPage );
		connect( newPage, TQT_SIGNAL( newParent( TabBox* ) ), this, TQT_SIGNAL( newTabBox( TabBox* ) ) );
		connect( newPage, TQT_SIGNAL( requestDestruction() ), this, TQT_SLOT( destroyChild() ) );
	}
}
///////////////////////////////////////
//
//	TabBox::removeTab
//
///////////////////////////////////////
void TabBox::removeTab( TQWidget *child, bool deleteChild )
{
	if( TQString( child->className() ) == "TabPage" )
	{
		emit saveTabGeometry( TQString( ((TabPage*)child)->getChild()->className() ), size() );
		myTabs->removePage( child );
	}
	else
	{
		emit saveTabGeometry( TQString( child->className() ), size() );
		myTabs->removePage( child->parentWidget() );
	}

	/* Delete it if requested */
	if( deleteChild )
	{
		delete child;
	}
}
///////////////////////////////////////
//
//	TabBox::showTab
//
///////////////////////////////////////
void TabBox::showTab( TQWidget *child )
{
	if( isChild( child ) )
		myTabs->showPage( child->parentWidget() );
}
///////////////////////////////////////
//
//	TabBox::destroyChild
//
///////////////////////////////////////
void TabBox::destroyChild( void )
{
	TQObject *child = ((TQObject*)sender());

	/* Be careful... make sure we have a valid child calling us */
	if( child == NULL )
		return;
	if( !child->isWidgetType() )
		return;
	if( !isChild( ((TQWidget*)child) ) )
		return;

	/* Nuke it */
	removeTab( ((TQWidget*)child), TRUE );

	if( count() == 0 )
	{
		/* TabManager will be notified of the delete via TQObject::destroyed(TQObject*) */
		delete this;
	}
}
///////////////////////////////////////
//
//	TabBox::changeMyCaption
//
///////////////////////////////////////
void TabBox::changeMyCaption( TQWidget *child )
{
	setCaption( i18n("%1 - Knights").arg( myTabs->tabLabel( child ) ) );
}
///////////////////////////////////////
//
//	TabBox::count
//
///////////////////////////////////////
int TabBox::count( void )
{
	return myTabs->count();
}
///////////////////////////////////////
//
//	TabBox::isChild
//
///////////////////////////////////////
bool TabBox::isChild( TQWidget *child )
{
	for( int tmp=0; tmp < myTabs->count(); tmp++ )
	{
		if( myTabs->page(tmp) == child )
			return TRUE;
		if( ((TabPage*)myTabs->page(tmp))->getChild() == child )
			return TRUE;
	}
	return FALSE;
}
///////////////////////////////////////
//
//	TabBox::changeCaption
//
///////////////////////////////////////
void TabBox::changeCaption( TQWidget *child, const TQString &caption )
{
	if( TQString( child->className() ) == "TabPage" )
	{
		((TabPage*)child)->setCaption( caption );
		myTabs->setTabLabel( child, caption );
	}
	else if( isChild( child ) )
	{
		((TabPage*)child->parentWidget())->setCaption( caption );
		myTabs->setTabLabel( child->parentWidget(), caption );
	}
	changeMyCaption( myTabs->currentPage() );
}
