/***************************************************************************
                          setpagedisplay.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGEDISPLAY_H
#define SETPAGEDISPLAY_H

#include <klineedit.h>
#include <kcombobox.h>
#include <tqtextview.h>
#include <tqtabwidget.h>
#include <tqbuttongroup.h>
#include <tqpushbutton.h>
#include <tqslider.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvbox.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqlayout.h>
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageDisplay : public TQVBoxLayout
{
   Q_OBJECT
  TQ_OBJECT

	public:
													setPageDisplay(TQWidget *parent=0, resource *Rsrc=0);
													~setPageDisplay();
		void									buildThemeList( void );
		int										NewBoards;
		int										NewChessmen;
		bool									changeTheme;
		bool									refreshBoard;
		bool									rebuildConsole;
					
	public slots:
		void									slotCurrent_Boards( int );
		void									slotCurrent_Chessmen( int );
		void									slotCurrent_Theme_Size( int );
		void									slotToggle_Board_Orientation( bool );
		void									slotToggle_Splashscreen( bool );
		void									slotToggle_Auto_Preview( bool );
		void									slotToggle_Show_Last_Move( bool );
		void									slotToggle_Animate_Move( bool );
		void									slotToggle_Show_Coord( bool );
		void									slot_SCID_Images( const TQString& );
		void									slot_SCID_Images_Button( void );

		void									slot_setDefault(void);

		void									slot_Color_Background(void);
		void									slot_Color_Standard(void);
		void									slot_Color_PrivateTell(void);
		void									slot_Color_ChannelTell(void);
		void									slot_Color_Shout(void);
		void									slot_Color_Whisper(void);
		void									slot_Color_Notification(void);
		void									slot_Font_Standard(void);
		void									slot_Font_PrivateTell(void);
		void									slot_Font_ChannelTell(void);
		void									slot_Font_Shout(void);
		void									slot_Font_Whisper(void);
		void									slot_Font_Notification(void);
		
	signals:
		void									enableApply( void );

	protected:
		void									initTab1( void );
		void									initTab2( void );
		void									resetSampleConsole( void );
	
	private:
		resource							*Resource;
		int										margin;

		TQTabWidget						*TabParent;

													/* Tab 1 : General */
		TQVBox									*Tab1;
			TQHBox									*BOX_Themes;
				TQGroupBox							*GROUP_Boards;
					KComboBox							*Current_Boards;
				TQGroupBox							*GROUP_Chessmen;
					KComboBox							*Current_Chessmen;
			TQGroupBox							*GROUP_Theme_Size;
				TQLabel								*Size_Min;
				TQSlider								*Current_Theme_Size;
				TQLabel								*Size_Max;
			TQGroupBox							*GROUP_SCID_Images;
				KLineEdit							*EDIT_SCID_Images;
				TQPushButton						*BUTTON_SCID_Images;
			TQGroupBox							*GROUP_General_Graphics;
				TQCheckBox							*Board_Orientation;
				TQCheckBox							*Show_Splashscreen;
				TQCheckBox							*Auto_Preview;
				TQCheckBox							*Show_Last_Move;
				TQCheckBox							*Animate_Move;
				TQCheckBox							*Show_Coord;

													/* Tab 2 : Console */
		TQFrame								*Tab2;
			TQGridLayout							*GRID_Style;
				TQTextView								*Console_Sample;
				TQPushButton							*Default_Button;
				TQPushButton							*Fonts_Button_Standard;
				TQPushButton							*Fonts_Button_PrivateTell;
				TQPushButton							*Fonts_Button_ChannelTell;
				TQPushButton							*Fonts_Button_Shout;
				TQPushButton							*Fonts_Button_Whisper;
				TQPushButton							*Fonts_Button_Notification;
				TQPushButton							*Colors_Button_Standard;
				TQPushButton							*Colors_Button_PrivateTell;
				TQPushButton							*Colors_Button_ChannelTell;
				TQPushButton							*Colors_Button_Shout;
				TQPushButton							*Colors_Button_Whisper;
				TQPushButton							*Colors_Button_Notification;
				TQPushButton							*Colors_Button_Background;
};

#endif
