/***************************************************************************
                          dlg_engine.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_ENGINE_H
#define DLG_ENGINE_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqstring.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class dlg_engine : public KDialogBase
{
   Q_OBJECT
  TQ_OBJECT
	public:
									dlg_engine(TQWidget *parent=0, const char *name=0, resource *Rsrc=0, TQString ItemName="" );
									~dlg_engine();

	public slots:
		void					slotOk( void );
		void					slotApply( void );
		void					slotCancel( void );
		void					slotFilenameDialog( void );
		void					slotLogFileDialog( void );
		void					slotProtocol( int Index );

	private:
		engineList::Iterator	enginesIT;
		resource							*Resource;
		TQString								Name;

		TQVBox									*BOX_Parent;
		TQHBox									*BOX_NameProto;

		TQGroupBox							*BOX_Name;
		KLineEdit							*EDIT_Name;

		TQGroupBox							*BOX_Protocol;
		KComboBox							*EDIT_Protocol;

		TQGroupBox							*BOX_Filename;
		KLineEdit							*EDIT_Filename;
		TQPushButton						*BUTTON_Filename;

		TQGroupBox							*BOX_LogFile;
		KLineEdit							*EDIT_LogFile;
		TQPushButton						*BUTTON_LogFile;

		TQGroupBox							*BOX_Arguments;
		KLineEdit							*EDIT_Arguments;
};

#endif
