/***************************************************************************
 *
 * knetworkmanager-strongswan.h - A NetworkManager frontend for KDE
 *
 * Author: Thomas Kallenberg <tkallenb@hsr.ch>, <thomas@no-more-secrets.ch>
 *
 * Strongly based on the Code of Helmut Schaa <hschaa@suse.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_STRONGSWAN_H
#define KNETWORKMANAGER_STRONGSWAN_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>

#include "knetworkmanager-vpnplugin.h"
#include "strongswanprop.h"
#include "strongswanauth.h"

class StrongswanPlugin : public VPNPlugin
{
	Q_OBJECT
  TQ_OBJECT
	public:
		StrongswanPlugin(TQObject*, const char*, const TQStringList&);
		~StrongswanPlugin();

		VPNConfigWidget* CreateConfigWidget(TQWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent=0);
};

class StrongswanConnectionType
{
    public:
        enum CONNECTIONTYPE
        {
          UNKNOWN = -1
        , psk = 0
        , key
        , agent
        };

        static CONNECTIONTYPE mapString2ConnectionType(int string);
        static int mapConnectionType2String(CONNECTIONTYPE connectionType);
};

class StrongswanConfig : public VPNConfigWidget
{
	Q_OBJECT
  TQ_OBJECT
	public:
		void setVPNData(const TQStringList& routes, const TQMap<TQString, TQString>& properties);
		TQMap<TQString, TQString> getVPNProperties();
		TQStringList getVPNRoutes();
		bool hasChanged();
		bool isValid(TQStringList& );

		StrongswanConfig(TQWidget* parent);
		~StrongswanConfig();

	private:
		StrongswanConfigWidget*   _strongswanWidget;

	protected slots:
		void languageChange();
};

class StrongswanAuthentication : public VPNAuthenticationWidget
{
	Q_OBJECT
  TQ_OBJECT
	public:
		StrongswanAuthentication(TQWidget* parent = NULL, char* name = NULL);
		~StrongswanAuthentication();
		TQMap<TQString, TQString> getPasswords();
		void setPasswords(TQString name, TQString value);

	private:
		StrongswanAuthenticationWidget* _strongswanAuth;
};

#endif /* KNETWORKMANAGER_STRONGSWAN_H */
