/***************************************************************************
 *
 * knetworkmanager-wired_device_tray.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// TQt includes
#include <tqevent.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqbitmap.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqpixmapcache.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>

// TQt DBus
#include <tqdbusobjectpath.h>


// KNM includes
#include "knetworkmanager-wired_device_tray.h"
#include "knetworkmanager-wired_device.h"
#include "knetworkmanager-menuitem.h"
#include "knetworkmanager-menu_subhead.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-wired_connection.h"
#include "knetworkmanager-nm_proxy.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_settings_dialog.h"

using namespace ConnectionSettings;

class WiredDeviceTrayPrivate
{
	public:
		WiredDeviceTrayPrivate() {}
		~WiredDeviceTrayPrivate() {}

		WiredDevice* dev;
};

void WiredDeviceTray::newConnection()
{
	// create a new wired connection
	Connection* conn = new WiredConnection();

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, NULL, tray(), "connect_something", false, TQt::WDestructiveClose);
	dlg->show();
}


void WiredDeviceTray::addMenuItems(KPopupMenu* menu)
{
	ConnectionStore* connectionStore = ConnectionStore::getInstance();

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", TQString("Wired Connection (%1)").arg(d->dev->getInterface()), SmallIcon("wired", TQIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

    // bolding subhead instead
	//menu->insertSeparator();

	if (!d->dev->getCarrier())
	{
		// no carrier -> do not show any connections
		subhead = new Subhead(menu, "subhead2", i18n("Cable disconnected"), SmallIcon("no", TQIconSet::Automatic));
		menu->insertItem(subhead, -1, -1);
	}
	else
	{
		NMProxy* nm = NMProxy::getInstance();
		Connection* active_conn = nm->getActiveConnection(d->dev);
		if (active_conn)
			kdDebug() << active_conn->getObjectPath().data() << endl;

		// get all available Connections for wired devices
		TQValueList<Connection*> connections = connectionStore->getConnections(NM_SETTING_WIRED_SETTING_NAME);
		int connectionItems = 0;
		for (TQValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
		{
			WiredConnection* wiredconn = dynamic_cast<WiredConnection*>(*it);
			if (wiredconn)
			{
				// wired connection found :)
				Info* info = wiredconn->getInfoSetting();
				IPv4* ip = wiredconn->getIPv4Setting();

				// lets create a nice name for this connection
				if (info)
				{
					TQString title = info->getName();
					if (ip)
						title += TQString(" (%1)").arg(ip->getMethod() == IPv4::METHOD_DHCP ? i18n("DHCP") : i18n("Manual IP config"));
	
					NetworkMenuItem* item = new NetworkMenuItem(d->dev, wiredconn, TQT_TQOBJECT(menu));
					connectionItems += 1;

					int id = menu->insertItem(title, item, TQT_SLOT(slotActivate()));
					menu->setItemChecked(id, ((*it) == active_conn));
				}
			}
		}

		if ( connectionItems == 0) {
			// menu->insertSeparator();
			int id = menu->insertItem(SmallIcon("filenew", TQIconSet::Automatic), i18n("Create new wired connection"), this, TQT_SLOT(newConnection()));
		}
		// bring the device down
		KAction* deactivate = tray()->actionCollection()->action("deactivate_device");
		if (deactivate)
			deactivate->plug(menu);

	}
}

WiredDeviceTray::WiredDeviceTray (WiredDevice* dev, KSystemTray * parent, const char * name )
	: DeviceTrayComponent (dev, parent, name)
{
	d = new WiredDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(NM_DEVICE_STATE_ACTIVATED, "nm_device_wired");

}

WiredDeviceTray::~WiredDeviceTray ()
{
	delete d;
}

#include "knetworkmanager-wired_device_tray.moc"
