/***************************************************************************
 *
 * knetworkmanager-devicestore.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICESTORE_H
#define KNETWORKMANAGER_DEVICESTORE_H

#include "knetworkmanager.h"

class TQT_DBusObjectPath;
class DeviceStorePrivate;
class Device;

class DeviceStore : public TQObject
{
	Q_OBJECT
  TQ_OBJECT

	public:
		static DeviceStore* getInstance();
		TQValueList<Device*> getDevices(TQ_UINT32 type = 0);
		Device* getDevice(TQT_DBusObjectPath);

	public slots:
		void slotDeviceAdded(const TQT_DBusObjectPath&);
		void slotDeviceRemoved(const TQT_DBusObjectPath&);

	protected:
	  DeviceStore  ( TQObject * parent = 0, const char * name = 0);
	  ~DeviceStore ();

	signals:
		void DeviceStoreChanged();
		void DeviceAdded(Device*);
		void DeviceRemoved(Device*);

	private:
		void updateDevices();
		Device* createDevice(const TQT_DBusObjectPath&);

		DeviceStorePrivate* d;
};

#endif /* KNETWORKMANAGER_DEVICESTORE_H */
