/***************************************************************************
 *
 * knetworkmanager-device.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_ACCESSPOINT_H
#define KNETWORKMANAGER_ACCESSPOINT_H

#include "knetworkmanager.h"
#include <tqdbusvariant.h>

class AccessPointPrivate;
namespace DBus
{
	class AccessPointProxy;
};

class AccessPoint : public TQObject
{
	Q_OBJECT
  TQ_OBJECT
	public:
		AccessPoint (const AccessPoint&);
	  AccessPoint (TQString objpath = TQString(), TQObject * parent = 0, const char * name = 0);
	  ~AccessPoint ();

		AccessPoint& operator= (const AccessPoint& other);
		bool operator== (const AccessPoint& other) const;

    TQ_UINT32   getFlags() const;
    TQ_UINT32   getWpaFlags() const;
    TQ_UINT32   getRsnFlags() const;
    TQValueList<TQ_UINT8> getSsid() const;
    TQ_UINT32   getFrequency() const;
    TQString    getHwAddress() const;
    TQ_INT32    getMode() const;
    TQ_UINT32   getRate() const;
    TQ_UINT8    getStrength() const;
		TQString    getDisplaySsid() const;
		const TQByteArray getSsidByteArray() const;
		bool       isEncrypted() const;
		TQString    getObjectPath() const;
		bool       isValid() const;
	signals:
		void strengthChanged(TQ_UINT8);
	private slots:
		void slotPropertiesChanged(const TQMap<TQString, TQT_DBusVariant>& properties);
		void updateProperties();

	private:

	  AccessPointPrivate * d;
};

#endif /* KNETWORKMANAGER_DEVICE_H */
