/***************************************************************************
                          kmymoneylistviewitem  -  description
                             -------------------
    begin                : Wed Jun 28 2006
    copyright            : (C) 2000-2006 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

#include <tqpalette.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneylistviewitem.h"
#include "kmymoneychecklistitem.h"
#include "../kmymoneyglobalsettings.h"

KMyMoneyListViewItem::KMyMoneyListViewItem(TQListView* parent, const TQString& txt, const TQString& key, const TQString& id) :
  KListViewItem(parent, txt),
  m_key(key),
  m_id(id),
  m_isOdd(0),
  m_isKnown(0)
{
  if(key.isEmpty())
    m_key = txt;
}

KMyMoneyListViewItem::KMyMoneyListViewItem(TQListViewItem* parent, const TQString& txt, const TQString& key, const TQString& id) :
  KListViewItem(parent, txt),
  m_key(key),
  m_id(id),
  m_isOdd(0),
  m_isKnown(0)
{
  if(key.isEmpty())
    m_key = txt;
}

KMyMoneyListViewItem::~KMyMoneyListViewItem()
{
}

TQString KMyMoneyListViewItem::key(int column, bool ascending) const
{
  Q_UNUSED(ascending);

  if(column == 0)
    return m_key[0] + text(0);
  return m_key.mid(1);
}


void KMyMoneyListViewItem::paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment)
{
  TQColorGroup _cg = cg;
  _cg.setColor(TQColorGroup::Base, backgroundColor());

  // make sure to bypass KListViewItem::paintCell() as
  // we don't like it's logic - that's why we do this
  // here ;-)    (ipwizard)
  TQListViewItem::paintCell(p, _cg, column, width, alignment);
}

const TQColor KMyMoneyListViewItem::backgroundColor()
{
  return isAlternate() ? KMyMoneyGlobalSettings::listBGColor() : KMyMoneyGlobalSettings::listColor();
}

bool KMyMoneyListViewItem::isAlternate(void)
{
// logic taken from KListViewItem::isAlternate()
  KMyMoneyCheckListItem* ciAbove;
  KMyMoneyListViewItem* liAbove;
  ciAbove = dynamic_cast<KMyMoneyCheckListItem*> (itemAbove());
  liAbove = dynamic_cast<KMyMoneyListViewItem*> (itemAbove());

  m_isKnown = ciAbove ? ciAbove->m_isKnown : (liAbove ? liAbove->m_isKnown : true);
  if(m_isKnown) {
    m_isOdd = ciAbove ? !ciAbove->m_isOdd : (liAbove ? !liAbove->m_isOdd : false);
  } else {
    KMyMoneyCheckListItem* clItem;
    KMyMoneyListViewItem* liItem;
    bool previous = true;
    if(TQListViewItem::parent()) {
      clItem = dynamic_cast<KMyMoneyCheckListItem *>(TQListViewItem::parent());
      liItem = dynamic_cast<KMyMoneyListViewItem*>(TQListViewItem::parent());
      if(clItem)
        previous = clItem->m_isOdd;
      else
        previous = liItem->m_isOdd;
      clItem = dynamic_cast<KMyMoneyCheckListItem *>(TQListViewItem::parent()->firstChild());
      liItem = dynamic_cast<KMyMoneyListViewItem*>(TQListViewItem::parent()->firstChild());
    } else {
      clItem = dynamic_cast<KMyMoneyCheckListItem *>(listView()->firstChild());
      liItem = dynamic_cast<KMyMoneyListViewItem*>(listView()->firstChild());
    }
    while(clItem || liItem) {
      if(clItem) {
        clItem->m_isOdd = previous = !previous;
        clItem->m_isKnown = true;
        liItem = dynamic_cast<KMyMoneyListViewItem *>(clItem->nextSibling());
        clItem = dynamic_cast<KMyMoneyCheckListItem *>(clItem->nextSibling());
      } else if(liItem) {
        liItem->m_isOdd = previous = !previous;
        liItem->m_isKnown = true;
        clItem = dynamic_cast<KMyMoneyCheckListItem *>(liItem->nextSibling());
        liItem = dynamic_cast<KMyMoneyListViewItem *>(liItem->nextSibling());
      }
    }
  }
  return m_isOdd;
}

#include "kmymoneylistviewitem.moc"
