/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptioneditprotocol.h"


// QT includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditorprotocol.h"

namespace KMF {
KMFRuleOptionEditProtocol::KMFRuleOptionEditProtocol(TQObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditProtocol::KMFRuleOptionEditProtocol(TQObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorProtocol( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,TQT_SIGNAL(sigHideMe() ), 
		this,TQT_SLOT( slotShowOverview() ) );
}

KMFRuleOptionEditProtocol::~KMFRuleOptionEditProtocol() {}



void KMFRuleOptionEditProtocol::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditProtocol::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}



const TQString& KMFRuleOptionEditProtocol::optionEditName() const {
	return *( new TQString( i18n("Protocol Option") ) );
}
const TQString& KMFRuleOptionEditProtocol::description() const {
	return *( new TQString( i18n("This plugin manages the Protocol based options of iptables.") ) );
}

void KMFRuleOptionEditProtocol::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditProtocol::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleOptionEditProtocol::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditProtocol::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditProtocolFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditProtocolFactory::s_about = 0L;

KMFRuleOptionEditProtocolFactory::KMFRuleOptionEditProtocolFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditProtocolFactory" );
}

TQObject* KMFRuleOptionEditProtocolFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleOptionEditProtocol( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditProtocolFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditProtocolFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_protocol() {
		return new KMFRuleOptionEditProtocolFactory;
	}
}

}

#include "kmfruleoptioneditprotocol.moc"
