/***************************************************************************
 begin                : Wed Mar 13 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorlimit.h"

// qt includes
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kapplication.h>
#include <kmessagebox.h>

// Project includes
#include "../../core/iptruleoption.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
#include "../../core/xmlnames.h"
namespace KMF {
KMFRuleEditorLimit::KMFRuleEditorLimit( TQWidget *parent, const char *name, WFlags fl /*,IPTRule* cr*/ ) : KMyFirewallRuleEditorLimit( parent, name, fl ) {}
KMFRuleEditorLimit::~KMFRuleEditorLimit() {}
void KMFRuleEditorLimit::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditorLimit::loadRule( IPTRule * rule )" << endl;
	m_rule = rule;
	c_use_limit->setChecked( false );
	c_limit->setChecked( false );
	sb_limit->setValue( 5 );
	cb_interval->setCurrentItem( 0 );
	c_burst->setChecked( false );
	readRuleConfig();
}

void KMFRuleEditorLimit::readRuleConfig() {

	IPTRuleOption *opt = 0;
	opt = m_rule->getOptionForName("limit_opt");
	if (opt) {
		TQStringList vals = opt->getValues();
		TQString limit = "";
		TQString burst = "";
		limit = *vals.at(1);
		burst = *vals.at(2);
		if ( limit != XML::Undefined_Value ) {
			c_use_limit->setChecked( true );
			c_limit->setChecked( true );
			int i = limit.find( "/" );
			TQString str_rate = limit.left( i );
			kdDebug() << "Found Rate: " << str_rate << endl;
			int rate = str_rate.toInt();
			sb_limit->setValue( rate );
			TQString interval = limit.right( limit.length() - i - 1 );
			kdDebug() << "Found Limit: " << str_rate << "/" << interval << endl;
			//cb_interval->setEnabled(true);
			if ( interval == "second" )
				cb_interval->setCurrentItem( 0 );
			if ( interval == "minute" )
				cb_interval->setCurrentItem( 1 );
			if ( interval == "hour" )
				cb_interval->setCurrentItem( 2 );
		}
		if ( burst != XML::Undefined_Value ) {
			c_burst->setChecked( true );
			kdDebug() << "Found Burst: " << burst << endl;
			int rate = burst.toInt();
			sb_burst->setValue( rate );
		}
	}
}

void KMFRuleEditorLimit::slotOk() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Limit Option").arg( m_rule->name() ) 
	);
	TQPtrList<TQString>* options = new TQPtrList<TQString>;
	TQString* name = new TQString( "limit_opt" );
	if ( c_use_limit->isChecked() ) {
		TQString* opt = new TQString( "" );
		if ( !c_limit->isChecked() && !c_burst->isChecked() ) {
			KMessageBox::sorry( this, i18n( "You cannot enable a limit without at least the rate." ), i18n( "Limit Matches" ) );
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		if ( c_limit->isChecked() ) {
			TQString str_rate = sb_limit->text();
			TQString interval = cb_interval->currentText();
			opt->append( str_rate );
			opt->append( "/" );
			opt->append( interval );
			options->append( new TQString( XML::BoolOn_Value )  );
			options->append( opt );
			if ( c_burst->isChecked() ) {
				str_rate = sb_burst->text();
				TQString* burst_rate = new TQString( str_rate );
				options->append( burst_rate );
			} else {
				options->append( new TQString( XML::BoolOff_Value )  );
				options->append( new TQString( XML::BoolOff_Value )  );
			}
		} else {
			options->append( new TQString( XML::BoolOff_Value )  );
			options->append( new TQString( XML::BoolOff_Value )  );
		}
	}
	m_rule->addRuleOption( *name, *options );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditorLimit::slotHelp() {
	kdDebug() << "void KMFRuleEditorLimit::slotHelp()" << endl;
	kapp->invokeHelp( "limit" );
}

void KMFRuleEditorLimit::reject() {
	kdDebug() << "void KMFRuleEditorLimit::reject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleeditorlimit.moc"
