/***************************************************************************
 begin                : Tue Mar 5 2002
 copyright            : (C) 2002 by Christian Hubinger
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/ 
//MY includes
#include "kmfruleeditorinterface.h"

// QT includes
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqmessagebox.h>
#include <tqcombobox.h>
#include <tqgroupbox.h> 

// KDE includes
#include <kcombobox.h>
#include <kurl.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kdebug.h> 
#include <klocale.h> 

// project include
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfconfig.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
#include "../../core/xmlnames.h"
namespace KMF {
KMFRuleEditorInterface::KMFRuleEditorInterface( TQWidget *parent, const char *name, WFlags fl /*,IPTRule* cr */ ) : KMyFirewallRuleEditorInterface( parent, name, fl ) {
}
KMFRuleEditorInterface::~KMFRuleEditorInterface() {}

void KMFRuleEditorInterface::loadRule( IPTRule * rule ) {
	kdDebug() << "void  KMFRuleEditorInterface::loadRule( IPTRule * rule )" << endl;
	slotReadConfig();
	c_in_int->setChecked( false );
	c_inv_in_int->setChecked( false );
	cb_in_int->setCurrentItem( 0 );
	c_out_int->setChecked( false );
	c_inv_out_int->setChecked( false );
	cb_out_int->setCurrentItem( 0 );
	m_rule = rule;

	IPTRuleOption* opt = 0;
	opt = m_rule->getOptionForName("interface_opt");
	if ( opt ) {
		TQStringList vals = opt->getValues();
		TQString in = *vals.at(0);
		TQString out = *vals.at(1);
		if ( ! in.isEmpty() &&  in != XML::Undefined_Value && in != XML::BoolOff_Value ) {
			c_in_int->setChecked( true );
			if ( in.startsWith( "! " ) ) {
					c_inv_in_int->setChecked( true );
					cb_in_int->setEditText( in.right( in.length() - 2 ) );
			} else {
			cb_in_int->setEditText( in );
			}
		} else {
			c_in_int->setChecked( false );
		}
		if ( ! out.isEmpty() &&  out != XML::Undefined_Value && out != XML::BoolOff_Value ) {
			c_out_int->setChecked( true );
			if ( out.startsWith( "! " ) ) {
					c_inv_out_int->setChecked( true );
					cb_out_int->setEditText( out.right( out.length() - 2 ) );
			} else {
			cb_out_int->setEditText( out );
			}
		} else {
			c_out_int->setChecked( false );
		}

	}
	gb_in_int->setEnabled( true );
	gb_out_int->setEnabled( true );
}

/** No descriptions */
void KMFRuleEditorInterface::slotOk() {
	//  KMyFirewallRuleEditor* ed = (KMyFirewallRuleEditor*)parentWidget();
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Interface Option").arg( m_rule->name() ) 
	);

	TQString out = cb_out_int->currentText();
	TQString in = cb_in_int->currentText();
	TQString* option_name = new TQString( "interface_opt" );
	TQPtrList<TQString>* args = new TQPtrList<TQString>;
	
	if ( c_in_int->isChecked() && !in.isEmpty() ) {
		bool inv = c_inv_in_int->isChecked();
		if ( inv ) {
			in.prepend( "! " );
		}
		TQString* opt = new TQString( in );
		args->append( opt );
	} 
	if ( c_out_int->isChecked() && !out.isEmpty() ) {
		bool inv = c_inv_out_int->isChecked();
		if ( inv ) {
			out.prepend( "! " );
		}
		TQString* opt = new TQString( out );
		args->append( opt );
	} 
	
	while ( args->count() < 2 ) {
		args->append( new TQString( XML::BoolOff_Value ) );
	}

	m_rule->addRuleOption( *option_name, *args );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

/** No descriptions */
void KMFRuleEditorInterface::slotCheckConfig() {}
/** No descriptions */
void KMFRuleEditorInterface::slotReadConfig() {
	cb_in_int->clear();
	cb_out_int->clear();
	// FIXME: Use From Target
	cb_in_int->insertStringList( KMFConfig::interfaces() );
	cb_out_int->insertStringList( KMFConfig::interfaces() );
}

void KMFRuleEditorInterface::slotHelp() {
	kdDebug() << "void KMFRuleEditorInterface::slotHelp()" << endl;
	kapp->invokeHelp( "interfaces" );
}
void KMFRuleEditorInterface::reject() {
	kdDebug() << "void KMFRuleEditorInterface::reject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleeditorinterface.moc"
