/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/


#ifndef KMYFIREWALL_H
#define KMYFIREWALL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <tqwidget.h>
#include <tqguardedptr.h>

// KDE includes
#include <kapplication.h>
#include <kmainwindow.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kurl.h>
#include <kparts/mainwindow.h>
#include <kparts/dockmainwindow.h>
#include <ktempfile.h>

// Project includes
#include "kmfwidgets/kmfmainwindow.h"
#include "core/kmyfirewallinterface.h"

class KAction;
class KActionMenu;
class KDockWidget;
class KTempFile;
class TQCloseEvent;
class TQStringList;
class TQWidgetStack;


namespace KMF {
class KMFNetwork;
class KMFDoc;
class KMFIPTDoc;
class KMFGenericDoc;
class KMFView;
class KMFError;
class KMFErrorHandler;
class KMFIPTDocOptions;
class KMFConfigDialog;
class KMFRuleEdit;
class KMFCompilerPlugin;
class KMFProcOut;
class KMFSelectInterface;
// class KMFSelectInterface;

class KMFTarget;

/** KMyFirewall is the base class of the project */
class KMyFirewall : public KMFMainWindow {
	Q_OBJECT
  TQ_OBJECT

public:
	KMyFirewall( TQWidget* parent = 0, const char *name = 0 );
	~KMyFirewall();
	// KMFDoc* doc();
	KMFNetwork*  network();
	virtual void showEditor();
	virtual void showOutput();
	virtual void setOutputWidget( TQWidget* );
	virtual void checkStatus();
	virtual void updateCaption();
	
public slots:    // Public slots
	void slotUndo();
	void slotRedo();
	void slotFileSaveAs();
	void slotFileSaveAsTemplate();
	void slotFileOpen();
	void slotFileNew();
	void slotFileClose();
	void slotConfigureToolbars();
	void slotNewToolbarConfig();
	void slotEditDocInfo();
	void slotEnableSave();
	void slotRestoreSession();
	void slotConfigureKMF();
	void slotLoadEmptyRuleset();
  	void slotLoadTemplate();
	void slotLoadFile( const TQString& );
	void toggleActions( bool );
	void slotEnableUndo( bool );
	void slotEnableRedo( bool );
	void slotQuitApp();
	void slotConfigChanged();
	void slotSelectInterface();
	void slotExportTargetConfig();
	void slotImportTargetConfig();
	void slotShowTransactionLog();
	
protected:
	bool checkRoot();
	void updateView();
	void enableUndo( bool );
	void enableRedo( bool );

protected slots:
	void initStatusBar();
	void initView();
	void initActions();
	void slotFileSave();
	void toggleToolBar();
	void toggleStatusBar();
	void slotShowEditor();
// 	void slotProcessExited( KProcess* );
// 	void slotReceivedOutput( KProcess*, char*, int );
// 	void slotReceivedError( KProcess*, char*, int );

private:    // member functions
	bool isTemplate();
	KMFError* parseDocument( const KURL& );
	KMFError* saveDocument( bool promptURL, bool asTemplate );
	KMFDoc* getDocumentLoaderForUrl( const KURL&, KMFError* );
	bool prepareForFileOpen( const KURL& url );
	void parseCommandLineArgs();
	//++++++++++++++

private:    // data
	TQWidget* m_editorWidget;
// 	KProcess* childproc;
// 	KProcess &operator<<( const TQString& arg );
/*	TQString m_processName;
	KTempFile *m_iptables_saveOutput;*/
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	
	KMFNetwork *m_network;
	KMFConfigDialog *m_configDlg;
	KMFSelectInterface *m_selInterface;
	
	KAction* actionQuit;
	KAction* actionNew;
	KAction* actionClose;
	KAction* actionOpen;
	KAction* actionSave;
	KAction* actionSaveAs;
	KAction* actionEditDocInfo;
	KAction* actionLoadTemplate;
	KAction* actionUndo;
	KAction* actionRedo;
	KAction* actionExportTargetConfig;	
	KAction* actionImportTargetConfig;	
	KAction* actionShowTransactionLog;
	
	bool saveQuit();
	void closeEvent ( TQCloseEvent * );
	TQWidgetStack* m_widgetStack;
	TQWidget *m_outputWidget;
	
	
	TQString m_fileToOpen;

signals:
	void documentChanged( KMFIPTDoc * );
// 	void processExited( KProcess * );
	void sigSplashShow( bool );
	void sigSplashShowMsg( const TQString& );
};
}
#endif
