//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFTRANSACTIONLOG_H
#define KMFTRANSACTIONLOG_H

#include <tqlistview.h>

#include "kmyfirewalltransactionlog.h"

class KPopupMenu;
class KProcess;
class KTempFile;
class KListView;
class KListViewItem;

namespace KMF {
class KMFTransaction;


class KMFTransactionLog : public KMyFirewallTransactionLog
{
		Q_OBJECT
  TQ_OBJECT
	
	public: static KMFTransactionLog* instance();
	
	public:
		
		~KMFTransactionLog();
		/*$PUBLIC_FUNCTIONS$*/

	public slots:
		/*$PUBLIC_SLOTS$*/
		void slotUpdateView();
		
	protected:
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/
		void slotUpdateStatistics();
		void slotClearStacks();
		void slotClearLog();
		void slotLog( const TQString& );
		void slotZoneRBM( TQListViewItem*, const TQPoint&, int );
		void slotShowDiff();
		void slotKompareExited( KProcess* );	
	private:
		KMFTransactionLog ( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		KListViewItem* setupListItem( KMFTransaction*, KListView*, KListViewItem*);
		
	// DATA
	private: 
		KPopupMenu *m_contextMenu;
		KMFTransaction* m_currentTransaction;
		KTempFile *m_undoXMLFile;
		KTempFile *m_redoXMLFile;
		
		static KMFTransactionLog* s_instance;
		
		
};
}
#endif

