//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "kmfselectinterface.h"

//  QT includes
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqcolor.h>

// KDE includes
#include <kdebug.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <kapplication.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kapplication.h>

// Project Includes
#include "../core/kmfconfig.h"
namespace KMF {
KMFSelectInterface::KMFSelectInterface( TQWidget *parent, const char *name, bool modal, WFlags fl )
		: KMyFirewallSelectInterface( parent, name, modal, fl ) {
	m_cob_interface->setBackgroundMode( PaletteBase, PaletteBase );
//	m_opt_showOnStartup->setBackgroundMode( PaletteButton );
	m_cob_interface->setBackgroundColor( TQColor( 204, 0, 49 ) );
	m_descs << i18n("<qt><p>The generic interface provides an easy-to-use tool for setting up common personal firewalls or simple network routers.</p></qt>");
	m_cob_interface->insertItem( i18n("Generic Interface") );
	m_lbl_descripton->setText( *m_descs.at( 0 ) );
	
	m_descs << i18n("<qt><p>The IPTable interface is meant to be used by advanced users who like to have full control over the rules generated; as such, the IPTables interface provides an almost 1-1 view on your iptables configuration.</p></qt>");
	m_cob_interface->insertItem( i18n("IPTables Interface") );
	KStandardDirs dir;
	TQString filename = dir.findResource( "data", "kmyfirewall/pics/kmf_snapshot_generic_interface.png" );
	TQPixmap *p = new TQPixmap( filename );
	m_pic_screenshot->setPixmap( *p );
		
		
		
		
		
		
	connect( m_cob_interface, TQT_SIGNAL( activated( int ) ), this, TQT_SLOT( slotInterfaceChanged( int ) ) );
	connect( m_cmd_ok, TQT_SIGNAL( clicked() ) , this, TQT_SLOT( accept() ) );	
	connect( m_cmd_help, TQT_SIGNAL( clicked() ) , this, TQT_SLOT( help() ) );
	connect( b_close, TQT_SIGNAL( clicked() ) , this, TQT_SLOT( reject() ) );
	
	adjustSize();
}

KMFSelectInterface::~KMFSelectInterface() {}

/*$SPECIALIZATION$*/
void KMFSelectInterface::slotInterfaceChanged( int index ) {
	kdDebug() << "KMFSelectInterface::slotInterfaceChanged( int index )" << endl;
	m_lbl_descripton->setText( *m_descs.at( index ) );
	
	KStandardDirs dir;
	TQString filename = "";
	switch ( index ) {
		case 0:
			filename = dir.findResource( "data", "kmyfirewall/pics/kmf_snapshot_generic_interface.png" );
			break;
		case 1:
			filename = dir.findResource( "data", "kmyfirewall/pics/kmf_snapshot_iptables_interface.png" );
			break;
	}
	TQPixmap *p = new TQPixmap( filename );
	m_pic_screenshot->setPixmap( *p );
}

void KMFSelectInterface::accept() {
	kdDebug() << "KMFSelectInterface::accept()" << endl;
	kdDebug() << "Found item: " << m_cob_interface->currentItem() << endl;
	switch ( m_cob_interface->currentItem() ) {
		case 0:
			KMFConfig::setUseGenericInterface( true );
// 			Config().m_useGenericInterface = true;
			break;
		case 1:
			KMFConfig::setUseGenericInterface( false );
// 			Config().m_useGenericInterface = false;
			break;
		default:
			KMFConfig::setUseGenericInterface( true );
// 			Config().m_useGenericInterface = true;	
	}
	KMFConfig::setShowSelInterface( ! m_opt_showOnStartup->isChecked() );
// 	Config().m_show_selInterface = ! m_opt_showOnStartup->isChecked();
// 	Config().write();
	KMFConfig::self()->writeConfig();
	TQDialog::accept();
}

void KMFSelectInterface::help() {
	kapp->invokeHelp( "gui_interfaces" );
}

void KMFSelectInterface::reject(){
	TQDialog::reject();
}

}

#include "kmfselectinterface.moc"

