//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFPROTOCOLLISTVIEW_H
#define KMFPROTOCOLLISTVIEW_H

#include "kmyfirewallprotocollistview.h"

#include <tqptrlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqpixmap.h>
#include <tquuid.h>



class TQListViewItem;

namespace KMF {
class KMFProtocolUsage;
class KMFProtocolCategory;
class KMFNetZone;
class KMFNetHost;

class KMFProtocolListView : public KMyFirewallProtocolListView {
		Q_OBJECT
  TQ_OBJECT

	public:
		KMFProtocolListView ( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KMFProtocolListView();
		/*$PUBLIC_FUNCTIONS$*/
		void setHost( KMFNetHost* host );
		void setZone( KMFNetZone* zone );
		void loadProtocols();
	public slots:
		/*$PUBLIC_SLOTS$*/

	protected:
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/
		void slotNewProtocolSelected( TQListViewItem* );
		void slotOnProtocolDeleted( TQObject* );
		
	private:
		TQGuardedPtr<KMFNetHost> *m_host;
		TQGuardedPtr<KMFNetZone> *m_zone;
		bool m_reloading;
		
	signals:
		void sigProtocolClicked( KMFProtocolUsage*, bool );
		void sigProtocolCategoryClicked( KMFProtocolCategory* );
};
}
#endif

