/***************************************************************************
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfportwidget.h"

#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqlabel.h>

#include <kcombobox.h>
#include <klocale.h>
#include <kdebug.h>

#include "../core/kmferror.h"

namespace KMF {
KMFPortWidget::KMFPortWidget( TQWidget *parent, const char *name ) : KMyFirewallPortWidget( parent, name ) {
	m_err = new KMFError();
	m_err->setErrType( KMFError::OK );
	m_err->setErrMsg( "" );
	TQStringList *l = new TQStringList();
	
	cb_port_name->clear();
	l->append( "tcpmux" );
	l->append( "tcpmux" );
	l->append( "echo" );
	l->append( "discard" );
	l->append( "systat" );
	l->append( "daytime" );
	l->append( "netstat" );
	l->append( "qotd" );
	l->append( "msp" );
	l->append( "chargen" );
	l->append( "ftp-data" );
	l->append( "ftp" );
	l->append( "fsp" );
	l->append( "ssh" );
	l->append( "telnet" );
	l->append( "smtp" );
	l->append( "time" );
	l->append( "rlp" );
	l->append( "nameserver" );
	l->append( "whois" );
	l->append( "re-mail-ck" );
	l->append( "domain" );
	l->append( "mtp" );
	l->append( "bootps" );
	l->append( "bootpc" );
	l->append( "tftp" );
	l->append( "gopher" );
	l->append( "rje" );
	l->append( "finger" );
	l->append( "www" );
	l->append( "link" );
	l->append( "kerberos" );
	l->append( "supdup" );
	l->append( "hostnames" );
	l->append( "iso-tsap" );
	l->append( "csnet-ns" );
	l->append( "rtelnet" );
	l->append( "pop2" );
	l->append( "pop3" );
	l->append( "sunrpc" );
	l->append( "auth" );
	l->append( "sftp" );
	l->append( "uucp-path" );
	l->append( "nntp" );
	l->append( "ntp" );
	l->append( "pwdgen" );
	l->append( "netbios-ns" );
	l->append( "netbios-dgm" );
	l->append( "netbios-ssn" );
	l->append( "imap2" );
	l->append( "snmp" );
	l->append( "snmp-trap" );
	l->append( "cmip-man" );
	l->append( "cmip-agent" );
	l->append( "mailq" );
	l->append( "xdmcp" );
	l->append( "nextstep" );
	l->append( "bgp" );
	l->append( "prospero" );
	l->append( "irc" );
	l->append( "smux" );
	l->append( "at-rtmp" );
	l->append( "at-rtmp" );
	l->append( "at-nbp" );
	l->append( "at-echo" );
	l->append( "at-zis" );
	l->append( "qmtp" );
	l->append( "z3950" );
	l->append( "ipx" );
	l->append( "imap3" );
	l->append( "pawserv" );
	l->append( "zserv" );
	l->append( "fatserv" );
	l->append( "rpc2portmap" );
	l->append( "codaauth2" );
	l->append( "ulistserv" );
	l->append( "ldap" );
	l->append( "https" );
	l->append( "snpp" );
	l->append( "saft" );
	l->append( "npmp-local" );
	l->append( "npmp-gui" );
	l->append( "hmmp-ind" );
	l->append( "ipp" );
	l->append( "exec" );
	l->append( "biff" );
	l->append( "login" );
	l->append( "who" );
	l->append( "shell" );
	l->append( "syslog" );
	l->append( "printer" );
	l->append( "talk" );
	l->append( "ntalk" );
	l->append( "route" );
	l->append( "timed" );
	l->append( "tempo" );
	l->append( "courier" );
	l->append( "conference" );
	l->append( "netnews" );
	l->append( "netwall" );
	l->append( "gdomap" );
	l->append( "gdomap" );
	l->append( "uucp" );
	l->append( "klogin" );
	l->append( "kshell" );
	l->append( "afpovertcp" );
	l->append( "remotefs" );
	l->append( "nntps" );
	l->append( "submission" );
	l->append( "ldaps" );
	l->append( "tinc" );
	l->append( "silc" );
	l->append( "kerberos-adm" );
	l->append( "webster" );
	l->append( "rsync" );
	l->append( "ftps-data" );
	l->append( "ftps" );
	l->append( "telnets" );
	l->append( "imaps" );
	l->append( "ircs" );
	l->append( "pop3s" );
	l->append( "socks" );
	l->append( "mysql" );
	l->append( "jabber-client" );
	l->append( "jabber-server" );
	l->append( "postgres" );
	l->append( "x11" );
	l->append( "x11-1" );
	l->append( "x11-2" );
	l->append( "x11-3" );
	l->append( "x11-4" );
	l->append( "x11-5" );
	l->append( "x11-6" );
	l->append( "x11-7" );
	l->append( "font-service" );
	l->append( "kerberos4" );
	l->append( "kerberos_master" );
	l->append( "passwd_server" );
	l->append( "krb_prop" );
	l->append( "krbupdate" );
	l->append( "kpasswd" );
	l->append( "swat" );
	l->append( "kpop" );
	l->append( "knetd" );
	l->append( "zephyr-srv" );
	l->append( "zephyr-clt" );
	l->append( "zephyr-hm" );
	l->append( "eklogin" );
	l->append( "linuxconf" );
	l->append( "poppassd" );
	l->sort();
	cb_port_name-> insertStringList( *l );
	sb_port1->setMaxValue( 65535 );
	sb_port2->setMaxValue( 65535 );
	sb_port1->setMinValue( 1 );
	sb_port2->setMinValue( 1 );
}

KMFPortWidget::~KMFPortWidget() {}

KMFError* KMFPortWidget::getPortString( TQString* value ) {
	TQString port1 = "";
	TQString port2 = "";
	TQString portname = "";
	TQString ddot = ":";
	if ( c_port_name->isChecked() ) {
		portname = cb_port_name->currentText();
		kdDebug() << "Found portname: " << portname << endl;
		value->append( portname );
		kdDebug() << "Return portname: " << *value << endl;
		m_err->setErrType( KMFError::OK );
		m_err->setErrMsg( "" );
		return m_err;
	} else {
		port1 = port1.setNum( sb_port1->value() );
		value->append( port1 );
		if ( c_portrange->isChecked() ) {
			port2 = port2.setNum( sb_port2->value() );
			value->append( ddot );
			value->append( port2 );
		}

		if ( c_inv->isChecked() ) {
			value->prepend( "! " );
		}
		m_err->setErrType( KMFError::OK );
		m_err->setErrMsg( "" );
		return m_err;
	}
	return m_err;
}

void KMFPortWidget::loadPortString( TQString& port ) {
	kdDebug() << "void KMFPortWidget::loadPortString(TQString&)" << endl;
	kdDebug() << "Try to load PortString: " << port << endl;
	setEnabled( true );
	if ( port.startsWith( "! " ) ) {
		port = port.right( port.length() - 2 );
		c_inv->setChecked( true );
	}

	int pos = -1;
	pos = port.find( ":" );
	if ( pos > -1 ) {
		c_port_name->setChecked( false );
		c_portrange->setChecked( true );
		sb_port2->setEnabled( true );
		l_to->setEnabled( true );
		c_port_name->setEnabled( false );

		TQString port1 = port.left( pos );
		TQString port2 = port.right( port.length() - pos - 1 );
		kdDebug() << "Found Ports: " << port1 << " and " << port2 << endl;
		int p1, p2;
		bool bp1, bp2;
		p1 = port1.toInt( &bp1, 10 );
		p2 = port2.toInt( &bp2, 10 );
		if ( p1 )
			sb_port1->setValue( p1 );
		if ( p2 )
			sb_port2->setValue( p2 );
	} else {
		kdDebug() << "Found Port: " << port << endl;
		int p;
		bool ok;
		p = port.toInt( &ok, 10 );
		if ( ok ) {
			sb_port1->setValue( p );
		} else {
			c_port_name->setChecked( true );
			
// 			for ( uint i = 0; i < c_port_name->count(); i++ ) {
// 				TQString tmp_item = c_port_name->text( i );
// 				if ( tmp_item == port ) {
// 					c_port_name->setCurrentItem( i );
// 				}
// 			}

			
			cb_port_name->setCurrentText( port );
			
		}
	}
}

void KMFPortWidget::reset() {
	c_portrange->setChecked( false );
	c_inv->setChecked( false );
	l_to->setEnabled( false );
	c_port_name->setChecked( false );
	cb_port_name->setCurrentItem( 0 );
	sb_port1->setValue( 0 );
	sb_port2->setValue( 0 );
}

}

#include "kmfportwidget.moc"
